package org.phosphoresce.webcore.ext.smartlayout.model;

import org.phosphoresce.lib.commons.util.StringUtil;
import org.phosphoresce.webcore.ext.smartlayout.exception.SmartLayoutTaglibProcessException;
import org.phosphoresce.webcore.ext.smartlayout.taglib.annotation.SmartTagModelConfig;
import org.phosphoresce.webcore.ext.smartlayout.taglib.util.SmartTagUtil;

/**
 * タブパネルコンテナタグモデルクラス<br>
 * 
 * @author Kitagawa<br>
 * 
 *<!--
 * 更新日		更新者			更新内容
 * 2013/03/13	Kitagawa		新規作成
 *-->
 */
@SmartTagModelConfig(startTemplate = "TabPanelS.vm", endTemplate = "TabPanelE.vm")
public class TabPanelModel extends AbstractModel {

	/**
	 * コンストラクタ<br>
	 */
	public TabPanelModel() {
		super();
	}

	/**
	 * モデル階層妥当性をチェックします。<br>
	 * @throws Throwable 不正な階層構造の場合にスローされます
	 * @see org.phosphoresce.webcore.ext.smartlayout.model.SmartTagModel#checkModelHierarchy()
	 */
	@Override
	protected void checkModelHierarchy() throws Throwable {
		/*
		 * 子タグがTabPageクラスでない場合はエラー
		 */
		for (SmartTagModel child : getChilds()) {
			if (!(child instanceof TabPageModel)) {
				throw new SmartLayoutTaglibProcessException("FSML00014", new Object[] { //
						getClass().getSimpleName(), //
								TabPageModel.class.getSimpleName(), //
								child == null ? "null" : child.getClass().getSimpleName() //
						});
			}
		}
	}

	/**
	 * モデルフィールドの補正処理を行います。<br>
	 * @param model 子モデルオブジェクト
	 * @see org.phosphoresce.webcore.ext.smartlayout.model.SmartTagModel#validateFields()
	 */
	@Override
	protected void validateFields() {
		if (StringUtil.isEmpty(getId())) {
			setId("tabPanel-" + SmartTagUtil.uniqueKey());
		}
		int count = 1;
		for (SmartTagModel child : getChilds()) {
			if (child instanceof TabPageModel) {
				((TabPageModel) child).setId(getId() + "-" + count++);
			}
		}
	}
}
