package org.phosphoresce.webcore.ext.smartlayout.model;

import org.phosphoresce.webcore.ext.smartlayout.taglib.annotation.SmartTagAttributeField;
import org.phosphoresce.webcore.ext.smartlayout.taglib.annotation.SmartTagModelConfig;

/**
 * リストボックスタグモデルクラス<br>
 * 
 * @author Kitagawa<br>
 * 
 *<!--
 * 更新日		更新者			更新内容
 * 2013/03/13	Kitagawa		新規作成
 *-->
 */
@SmartTagModelConfig(startTemplate = "ListBoxS.vm", endTemplate = "ListBoxE.vm")
public class ListBoxModel extends AbstractNamedModel {

	/** エレメントデータ */
	@SmartTagAttributeField
	private String data;

	/** データラベルキー */
	@SmartTagAttributeField(defaultValue = "label")
	private String labelKey;

	/** データ値キー */
	@SmartTagAttributeField(defaultValue = "value")
	private String valueKey;

	/** サイズ */
	@SmartTagAttributeField
	private String size;

	/** 複数選択 */
	@SmartTagAttributeField
	private boolean multiple;

	/**
	 * コンストラクタ<br>
	 */
	public ListBoxModel() {
		super();
	}

	/**
	 * エレメントデータを取得します。<br>
	 * @return エレメントデータ
	 */
	public String getData() {
		return data;
	}

	/**
	 * エレメントデータを設定します。<br>
	 * @param data エレメントデータ
	 */
	public void setData(String data) {
		this.data = data;
	}

	/**
	 * データラベルキーを取得します。<br>
	 * @return データラベルキー
	 */
	public String getLabelKey() {
		return labelKey;
	}

	/**
	 * データラベルキーを設定します。<br>
	 * @param labelKey データラベルキー
	 */
	public void setLabelKey(String labelKey) {
		this.labelKey = labelKey;
	}

	/**
	 * データ値キーを取得します。<br>
	 * @return データ値キー
	 */
	public String getValueKey() {
		return valueKey;
	}

	/**
	 * データ値キーを設定します。<br>
	 * @param valueKey データ値キー
	 */
	public void setValueKey(String valueKey) {
		this.valueKey = valueKey;
	}

	/**
	 * サイズを取得します。<br>
	 * @return サイズ
	 */
	public String getSize() {
		return size;
	}

	/**
	 * サイズを設定します。<br>
	 * @param size サイズ
	 */
	public void setSize(String size) {
		this.size = size;
	}

	/**
	 * 複数選択を取得します。<br>
	 * @return 複数選択
	 */
	public boolean isMultiple() {
		return multiple;
	}

	/**
	 * 複数選択を設定します。<br>
	 * @param multiple 複数選択
	 */
	public void setMultiple(boolean multiple) {
		this.multiple = multiple;
	}
}
