package org.phosphoresce.webcore.ext.smartlayout.model;

import org.phosphoresce.webcore.ext.smartlayout.taglib.annotation.SmartTagAttributeField;
import org.phosphoresce.webcore.ext.smartlayout.taglib.annotation.SmartTagModelConfig;

/**
 * フォームコンテナタグモデルクラス<br>
 * 
 * @author Kitagawa<br>
 * 
 *<!--
 * 更新日		更新者			更新内容
 * 2013/03/13	Kitagawa		新規作成
 *-->
 */
@SmartTagModelConfig(startTemplate = "FieldS.vm", endTemplate = "FieldE.vm")
public class FieldModel extends AbstractModel {

	/** ラベル */
	@SmartTagAttributeField
	private String label;

	/**
	 * コンストラクタ<br>
	 */
	public FieldModel() {
		super();
	}

	/**
	 * ラベルを取得します。<br>
	 * @return ラベル
	 */
	public String getLabel() {
		return label;
	}

	/**
	 * ラベルを設定します。<br>
	 * @param label ラベル
	 */
	public void setLabel(String label) {
		this.label = label;
	}

	/**
	 * モデルフィールドの補正処理を行います。<br>
	 * @param model 子モデルオブジェクト
	 * @see org.phosphoresce.webcore.ext.smartlayout.model.SmartTagModel#validateFields()
	 */
	@Override
	protected void validateFields() {
		for (SmartTagModel child : getChilds()) {
			if (child instanceof AbstractModel) {
				((AbstractModel) child).setTitle(label);
			}
		}
	}
}
