package org.phosphoresce.webcore.ext.smartlayout;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;

import org.apache.velocity.Template;
import org.apache.velocity.app.VelocityEngine;

/**
 * スマートレイアウトタグライブラリ提供アドオン環境変数保持クラス<br>
 * <br>
 * 当クラスはアプリケーション起動時に初期化され、アプリケーション実行中は永続的に情報を保持し続けます。<br>
 * 
 * @author Kitagawa<br>
 * 
 *<!--
 * 更新日		更新者			更新内容
 * 2010/07/06	Kitagawa		新規作成
 *-->
 */
public class SmartLayoutEnvironment implements Serializable, SmartLayoutConstants {

	/** Velocityテンプレートエンジン */
	private static VelocityEngine templateEngine = null;

	/** Velocityテンプレートキャッシュ */
	private static Map<String, Template> templates = new HashMap<String, Template>();

	/**
	 * 環境変数内容をMapオブジェクトとして取得します。<br>
	 * @return Mapオブジェクト
	 */
	public static Map<String, Object> getMap() {
		Map<String, Object> map = new HashMap<String, Object>();
		map.put("templateEngine", templateEngine);
		map.put("templates", templates);
		return map;
	}

	/**
	 * コンストラクタ<br>
	 */
	private SmartLayoutEnvironment() {
		super();
	}

	/**
	 * Velocityテンプレートエンジンを取得します。<br>
	 * @return Velocityテンプレートエンジン
	 */
	public static VelocityEngine getTemplateEngine() {
		return templateEngine;
	}

	/**
	 * Velocityテンプレートエンジンを設定します。<br>
	 * @param templateEngine Velocityテンプレートエンジン
	 */
	public static void setTemplateEngine(VelocityEngine templateEngine) {
		SmartLayoutEnvironment.templateEngine = templateEngine;
	}

	/**
	 * Velocityテンプレートキャッシュを設定します。<br>
	 * @param name テンプレート名
	 * @param template テンプレートオブジェクト
	 */
	public static void setTemplate(String name, Template template) {
		templates.put(name, template);
	}

	/**
	 * Velocityテンプレートキャッシュを取得します。<br>
	 * @param name テンプレート名
	 * @return template テンプレートオブジェクト
	 */
	public static Template getTemplate(String name) {
		return templates.get(name);
	}
}
