package org.phosphoresce.webcore.ext.smartlayout;

import org.phosphoresce.webcore.core.GlobalConstants;

/**
 * スマートレイアウトタグライブラリ提供アドオン定数インタフェース<br>
 * 
 * @author Kitagawa<br>
 * 
 *<!--
 * 更新日		更新者			更新内容
 * 2010/07/03	Kitagawa		新規作成
 *-->
 */
public interface SmartLayoutConstants extends GlobalConstants {

	/** Velocity環境設定リソース */
	public static final String SMART_LAYOUT_VELOCITY_CONFIG = "/" + SmartLayoutConstants.class.getPackage().getName().replaceAll("\\.", "/") + "/SmartLayoutVelocity.properties";

	/** Velocityテンプレートリソースパス */
	public static final String SMART_LAYOUT_VELOCITY_TEMPLATE_PATH = "/" + SmartLayoutConstants.class.getPackage().getName().replaceAll("\\.", "/") + "/template";

	/** Velocityバインドキー(モデルオブジェクト) */
	public static final String VELOCITY_KEY_MODEL = "model";

	/** Velocityバインドキー(フォームオブジェクト) */
	public static final String VELOCITY_KEY_FORM = "form";

	/** Velocityバインドキー(ユーティリティ) */
	public static final String VELOCITY_KEY_UTIL = "util";
}
