package org.phosphoresce.webcore.ext.smartlayout;

import java.io.File;

import org.apache.velocity.Template;
import org.apache.velocity.app.VelocityEngine;
import org.phosphoresce.lib.commons.util.FileUtil;
import org.phosphoresce.lib.commons.util.PropertiesUtil;
import org.phosphoresce.lib.commons.util.ResourceUtil;
import org.phosphoresce.webcore.core.logger.CodeConvertLogger;
import org.slf4j.LoggerFactory;

/**
 * スマートレイアウトタグライブラリ提供アドオン環境初期化クラス<br>
 * 
 * @author Kitagawa<br>
 * 
 *<!--
 * 更新日		更新者			更新内容
 * 2011/12/24	Kitagawa		新規作成
 *-->
 */
public class SmartLayoutConfiguration implements SmartLayoutConstants {

	/** ロガーオブジェクト */
	private static CodeConvertLogger log = new CodeConvertLogger(LoggerFactory.getLogger(SmartLayoutConfiguration.class));

	/**
	 * コンストラクタ<br>
	 */
	private SmartLayoutConfiguration() {
		super();
	}

	/**
	 * スマートレイアウトタグライブラリ提供アドオンの初期化処理を行います。<br>
	 * 当初期化処理はアプリケーション共通初期化処理が完了されていることが前提となります。<br>
	 */
	public synchronized static void configure() {
		try {
			log.output("FSML00001");

			/*
			 * テンプレートエンジン初期化
			 */
			VelocityEngine engine = new VelocityEngine(PropertiesUtil.load(SMART_LAYOUT_VELOCITY_CONFIG));
			engine.init();
			SmartLayoutEnvironment.setTemplateEngine(engine);

			/*
			 * テンプレートオブジェクトキャッシュ
			 */
			for (File file : FileUtil.getFiles(ResourceUtil.getFile(SMART_LAYOUT_VELOCITY_TEMPLATE_PATH), true)) {
				String templateName = file.getAbsolutePath().substring(ResourceUtil.getFile(SMART_LAYOUT_VELOCITY_TEMPLATE_PATH).getAbsolutePath().length());
				Template template = engine.getTemplate(FileUtil.connectPath(SMART_LAYOUT_VELOCITY_TEMPLATE_PATH, templateName));
				SmartLayoutEnvironment.setTemplate(file.getName(), template);
				log.output("FSML00005", file.getName());
			}

			log.output("FSML00002");
		} catch (Throwable e) {
			log.output(e, "FSML00004");
		}
	}

	/**
	 * スマートレイアウトタグライブラリ提供アドオンの破棄処理を実行します。<br>
	 * @throws Throwable 終了処理中に予期せぬエラーが発生した場合にスローされます 
	 */
	public synchronized static void destroy() throws Throwable {
		log.output("FSML00003");
	}
}
