package org.phosphoresce.webcore.ext.jod;

import org.phosphoresce.webcore.core.ConfigName;

/**
 * LibreOfficeドキュメントコンバートアドオン環境設定定義名定数インタフェース<br>
 * 
 * @author Kitagawa<br>
 * 
 *<!--
 * 更新日		更新者			更新内容
 * 2010/07/03	Kitagawa		新規作成
 *-->
 */
public class JODConfigName extends ConfigName {

	/** LibreOffice実行OS定義 */
	public static final JODConfigName JOD_SOFFICE_OS = new JODConfigName("jod.soffice.os");

	/** LibreOffice実行テンポラリパス定義 */
	public static final JODConfigName JOD_TEMPORARY_PATH = new JODConfigName("jod.temporary.path");

	/** LibreOffice実行コマンドパス定義 */
	public static final JODConfigName JOD_SOFFICE_PATH = new JODConfigName("jod.soffice.path");

	/** LibreOffice既存プロセス強制終了コマンド定義 */
	public static final JODConfigName JOD_SOFFICE_KILL_COMMAND = new JODConfigName("jod.socket.process.kill.command");

	/** LibreOfficeソケットサービスホスト定義 */
	public static final JODConfigName JOD_SOFFICE_SOCKET_HOST = new JODConfigName("jod.soffice.socket.host");

	/** LibreOfficeソケットサービス予約ポート(開始)定義 */
	public static final JODConfigName JOD_SOFFICE_SOCKET_PORT_START = new JODConfigName("jod.soffice.socket.port.start");

	/** LibreOfficeソケットサービス予約ポート(終了)定義 */
	public static final JODConfigName JOD_SOFFICE_SOCKET_PORT_END = new JODConfigName("jod.soffice.socket.port.end");

	/** LibreOfficeソケットサービスプロセス起動時強制終了フラグ */
	public static final JODConfigName JOD_SOFFICE_SOCKET_PROCESS_KILL_ON_STARTUP = new JODConfigName("jod.socket.process.kill.startup");

	/** LibreOfficeソケット接続維持フラグ */
	public static final JODConfigName JOD_SOFFICE_SOCKET_PROCESS_KEEP = new JODConfigName("jod.socket.process.keep");

	/** LibreOfficeソケット接続試行回数 */
	public static final JODConfigName JOD_SOFFICE_SOCKET_CONNECT_TEST_COUNT = new JODConfigName("jod.socket.connection.test.count");

	/** LibreOfficeソケット接続試行間隔(ミリ秒) */
	public static final JODConfigName JOD_SOFFICE_SOCKET_CONNECT_TEST_DELAY = new JODConfigName("jod.socket.connection.test.delay");

	/**
	 * コンストラクタ<br>
	 * @param key プロパティキー
	 */
	protected JODConfigName(String key) {
		super(key);
	}
}
