package org.phosphoresce.webcore.ext.jdbc.factory;

import java.sql.Connection;

import javax.naming.InitialContext;
import javax.sql.DataSource;

import org.phosphoresce.webcore.ext.jdbc.JDBCConstants;

/**
 * データソース利用データベースコネクションファクトリ<br>
 * 
 * @author Kitagawa<br>
 * 
 *<!--
 * 更新日		更新者			更新内容
 * 2011/12/24	Kitagawa		新規作成
 *-->
 */
public class JDBCDatasourceConnectionFactory extends JDBCConnectionFactory implements JDBCConstants {

	/** データソース参照名 */
	private String referenceName;

	/**
	 * コンストラクタ<br>
	 * @param referenceName データソース参照名
	 * @param autoCommit 自動コミットフラグ
	 */
	public JDBCDatasourceConnectionFactory(String referenceName, boolean autoCommit) {
		super(autoCommit);
		this.referenceName = referenceName;
	}

	/**
	 * データベースコネクションを生成します。<br>
	 * @return データベースコネクションオブジェクト
	 * @throws Throwable 正常にデータベースコネクションが確立できなかった場合にスローされます
	 * @see org.phosphoresce.webcore.ext.jdbc.factory.JDBCConnectionFactory#createConnection()
	 */
	@Override
	public Connection createConnection() throws Throwable {
		InitialContext context = new InitialContext();
		DataSource datasource = (DataSource) context.lookup("java:comp/env/" + referenceName);
		Connection connection = datasource.getConnection();
		connection.setAutoCommit(isAutoCommit());
		return connection;
	}
}
