package org.phosphoresce.webcore.ext.jasper.export;

import java.util.LinkedList;
import java.util.List;
import java.util.Locale;

import javax.print.DocFlavor;
import javax.print.PrintService;
import javax.print.PrintServiceLookup;
import javax.print.attribute.Attribute;
import javax.print.attribute.HashPrintServiceAttributeSet;
import javax.print.attribute.PrintServiceAttributeSet;
import javax.print.attribute.standard.PrinterName;

/**
 * JasperReportsラッピングフレームワークプリンタ関連ユーティリティクラス<br>
 * 
 * @author Kitagawa<br>
 * 
 *<!--
 * 更新日		更新者			更新内容
 * 2007/11/26	Kitagawa		新規作成
 *-->
 */
public final class JasperPrinterUtil {

	/**
	 * コンストラクタ<br>
	 */
	private JasperPrinterUtil() {
		super();
	}

	/**
	 * プリントサービス情報をデバッグします。<br>
	 */
	public static void debug() {
		PrintService[] services = getPrintServices();
		for (int cnt = 0; cnt < services.length; cnt++) {
			System.out.println("####################### PrintService - " + cnt);

			PrintService service = services[cnt];
			PrintServiceAttributeSet attributes = service.getAttributes();
			Attribute[] attribute = attributes.toArray();

			System.out.println("## PrintServiceAttribute");
			for (int i = 0; i < attribute.length; i++) {
				System.out.println(" --> " + attribute[i].getClass().toString() + "=" + attribute[i]);
			}

			DocFlavor[] glavors = service.getSupportedDocFlavors();
			System.out.println("## DocFlavor");
			for (int i = 0; i < glavors.length; i++) {
				DocFlavor flavor = glavors[i];
				System.out.println(" --> " + flavor.toString());
			}
		}
	}

	/**
	 * 定義されている全てのプリンタサービスを取得します。<br>
	 * @return 定義されている全てのプリンタサービス
	 */
	public static PrintService[] getPrintServices() {
		return PrintServiceLookup.lookupPrintServices(null, null);
	}

	/**
	 * 定義されている全てのプリンタサービスのプリンタ名を取得します。<br>
	 * @return 定義されている全てのプリンタサービスのプリンタ名
	 */
	public static String[] getPrinterNames() {
		List<String> list = new LinkedList<String>();
		PrintService[] services = getPrintServices();
		for (int i = 0; i <= services.length - 1; i++) {
			PrintService service = services[i];
			PrintServiceAttributeSet attributes = service.getAttributes();
			list.add(attributes.get(PrinterName.class).toString());
		}
		return (String[]) list.toArray(new String[list.size()]);
	}

	/**
	 * 指定されたプリンタ名のHashPrintServiceAttributeSetオブジェクトを生成します。<br>
	 * @param printername プリンタ名
	 * @return HashPrintServiceAttributeSetオブジェクト
	 */
	public static HashPrintServiceAttributeSet createPrintServiceAttributeSet(String printername) {
		HashPrintServiceAttributeSet attributes = new HashPrintServiceAttributeSet();
		attributes.add(new PrinterName(printername, Locale.getDefault()));
		return attributes;
	}
}
