package org.phosphoresce.webcore.ext.jasper;

import java.io.File;
import java.io.IOException;
import java.io.OutputStream;

import net.sf.jasperreports.engine.util.JRFontUtil;

import org.phosphoresce.lib.commons.util.FileUtil;
import org.phosphoresce.webcore.core.config.Config;
import org.phosphoresce.webcore.core.exception.WebcoreConfigurationException;
import org.phosphoresce.webcore.core.logger.CodeConvertLogger;
import org.phosphoresce.webcore.ext.jasper.export.JasperContainer;
import org.phosphoresce.webcore.ext.jasper.export.JasperExportType;
import org.phosphoresce.webcore.ext.jasper.export.JasperSingleWriter;
import org.slf4j.LoggerFactory;

/**
 * JasperReportsアドオン環境初期化クラス<br>
 * 
 * @author Kitagawa<br>
 * 
 *<!--
 * 更新日		更新者			更新内容
 * 2011/12/24	Kitagawa		新規作成
 *-->
 */
public class JasperConfiguration implements JasperConstants {

	/** ロガーオブジェクト */
	private static CodeConvertLogger log = new CodeConvertLogger(LoggerFactory.getLogger(JasperConfiguration.class));

	/**
	 * コンストラクタ<br>
	 */
	private JasperConfiguration() {
		super();
	}

	/**
	 * JasperReportsアドオンの初期化処理を行います。<br>
	 * 当初期化処理はアプリケーション共通初期化処理が完了されていることが前提となります。<br>
	 */
	public synchronized static void configure() {
		try {
			log.output("FJPR00001");

			/*
			 * JasperReportダミー出力(キャッシュによるレスポンス向上)
			 */
			int preloadSuccessCount = 0;
			int preloadFailCount = 0;
			JasperContainer container = new JasperContainer();
			for (File file : FileUtil.getFiles(new File(FileUtil.connectPath(Config.getString(JasperConfigName.JASPER_TEMPLATE_PATH))), true)) {
				if (file.getName().endsWith(JASPER_FORM_EXTENSION)) {
					JasperSingleWriter writer = new JasperSingleWriter(file.getAbsolutePath(), container);
					try {
						writer.write(JasperExportType.PDF, new OutputStream() {
							@Override
							public void write(int b) throws IOException {
								// ダミーストリーム出力
							}
						});
						preloadSuccessCount++;
					} catch (Throwable e) {
						// プリロード処理である為、例外は無視する
						log.output(e, "FJPR00003", file.getName());
						preloadFailCount++;
					}
					log.output("FJPR00004", file.getName());
				}
			}

			log.output("FJPR00012", String.valueOf(preloadSuccessCount), String.valueOf(preloadFailCount));
			log.output("FJPR00002");
		} catch (Throwable e) {
			throw new WebcoreConfigurationException("FJPR00006", e);
		}
	}

	/**
	 * JasperReportsアドオンの破棄処理を実行します。<br>
	 * @throws Throwable 終了処理中に予期せぬエラーが発生した場合にスローされます 
	 */
	public synchronized static void destroy() throws Throwable {
		JRFontUtil.resetThreadMissingFontsCache();
		log.output("FJPR00005");
	}
}
