package org.phosphoresce.webcore.ext.hibernate4.transaction;

import org.phosphoresce.webcore.core.transaction.TransactionContext;
import org.phosphoresce.webcore.ext.hibernate4.model.SMUser;

/**
 * Hibernateトランザクション処理コンテキストクラス<br>
 * 
 * @author Kitagawa<br>
 * 
 *<!--
 * 更新日		更新者			更新内容
 * 2013/02/01	Kitagawa		新規作成
 *-->
 */
public final class HibernateTransactionContext extends TransactionContext<HibernateTransactionManager, SMUser> {

	/** トランザクション名前空間 */
	private String namespace;

	/**
	 * コンストラクタ<br>
	 * @param transaction トランザクション管理オブジェクト
	 * @param processUser 処理ユーザ
	 * @param processTime 処理時刻
	 */
	public HibernateTransactionContext(HibernateTransactionManager transaction, SMUser processUser, long processTime) {
		super(transaction, processUser, processTime);
		this.namespace = namespace;
	}
}
