package org.phosphoresce.webcore.ext.hibernate4.transaction;

import java.util.List;

import org.hibernate.CacheMode;
import org.hibernate.Criteria;
import org.hibernate.FetchMode;
import org.hibernate.FlushMode;
import org.hibernate.HibernateException;
import org.hibernate.LockMode;
import org.hibernate.ScrollMode;
import org.hibernate.ScrollableResults;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Order;
import org.hibernate.criterion.Projection;
import org.hibernate.sql.JoinType;
import org.hibernate.transform.ResultTransformer;


/**
 * 非総称エンティティクラスCriteriaクラス<br>
 * 
 * @author Kitagawa<br>
 * 
 *<!--
 * 更新日		更新者			更新内容
 * 2013/02/01	Kitagawa		新規作成
 *-->
 */
public class GenericCriteria<E extends AbstractHibernateEntity> {

	/** HibernateCriteriaオブジェクト */
	private Criteria criteria;

	/**
	 * コンストラクタ<br>
	 * @param criteria HibernateCriteriaオブジェクト
	 */
	public GenericCriteria(Criteria criteria) {
		if (criteria == null) {
			throw new NullPointerException("criteria");
		}
		this.criteria = criteria;
	}

	/**
	 * @see org.hibernate.Criteria#getAlias()
	 */
	public String getAlias() {
		return criteria.getAlias();
	}

	/**
	 * @see org.hibernate.Criteria#setProjection(org.hibernate.criterion.Projection)
	 */
	public GenericCriteria<E> setProjection(Projection projection) {
		Criteria resultCriteria = criteria.setProjection(projection);
		if (criteria.equals(resultCriteria)) {
			return this;
		} else {
			return new GenericCriteria<E>(resultCriteria);
		}
	}

	/**
	 * @see org.hibernate.Criteria#add(org.hibernate.criterion.Criterion)
	 */
	public GenericCriteria<E> add(Criterion criterion) {
		Criteria resultCriteria = criteria.add(criterion);
		if (criteria.equals(resultCriteria)) {
			return this;
		} else {
			return new GenericCriteria<E>(resultCriteria);
		}
	}

	/**
	 * @see org.hibernate.Criteria#addOrder(org.hibernate.criterion.Order)
	 */
	public GenericCriteria<E> addOrder(Order order) {
		Criteria resultCriteria = criteria.addOrder(order);
		if (criteria.equals(resultCriteria)) {
			return this;
		} else {
			return new GenericCriteria<E>(resultCriteria);
		}
	}

	/**
	 * @see org.hibernate.Criteria#setFetchMode(java.lang.String, org.hibernate.FetchMode)
	 */
	public GenericCriteria<E> setFetchMode(String s, FetchMode fetchmode) throws HibernateException {
		Criteria resultCriteria = criteria.setFetchMode(s, fetchmode);
		if (criteria.equals(resultCriteria)) {
			return this;
		} else {
			return new GenericCriteria<E>(resultCriteria);
		}
	}

	/**
	 * @see org.hibernate.Criteria#setLockMode(org.hibernate.LockMode)
	 */
	public GenericCriteria<E> setLockMode(LockMode lockmode) {
		Criteria resultCriteria = criteria.setLockMode(lockmode);
		if (criteria.equals(resultCriteria)) {
			return this;
		} else {
			return new GenericCriteria<E>(resultCriteria);
		}
	}

	/**
	 * @see org.hibernate.Criteria#setLockMode(java.lang.String, org.hibernate.LockMode)
	 */
	public GenericCriteria<E> setLockMode(String s, LockMode lockmode) {
		Criteria resultCriteria = criteria.setLockMode(s, lockmode);
		if (criteria.equals(resultCriteria)) {
			return this;
		} else {
			return new GenericCriteria<E>(resultCriteria);
		}
	}

	/**
	 * @see org.hibernate.Criteria#createAlias(java.lang.String, java.lang.String)
	 */
	public GenericCriteria<E> createAlias(String s, String s1) throws HibernateException {
		Criteria resultCriteria = criteria.createAlias(s, s1);
		if (criteria.equals(resultCriteria)) {
			return this;
		} else {
			return new GenericCriteria<E>(resultCriteria);
		}
	}

	/**
	 * @see org.hibernate.Criteria#createAlias(java.lang.String, java.lang.String, org.hibernate.sql.JoinType)
	 */
	public GenericCriteria<E> createAlias(String s, String s1, JoinType jointype) throws HibernateException {
		Criteria resultCriteria = criteria.createAlias(s, s1, jointype);
		if (criteria.equals(resultCriteria)) {
			return this;
		} else {
			return new GenericCriteria<E>(resultCriteria);
		}
	}

	/**
	 * @see org.hibernate.Criteria#createAlias(java.lang.String, java.lang.String, org.hibernate.sql.JoinType, org.hibernate.criterion.Criterion)
	 */
	public GenericCriteria<E> createAlias(String s, String s1, JoinType jointype, Criterion criterion) throws HibernateException {
		Criteria resultCriteria = criteria.createAlias(s, s1, jointype, criterion);
		if (criteria.equals(resultCriteria)) {
			return this;
		} else {
			return new GenericCriteria<E>(resultCriteria);
		}
	}

	/**
	 * @see org.hibernate.Criteria#createCriteria(java.lang.String)
	 */
	public GenericCriteria<E> createCriteria(String s) throws HibernateException {
		Criteria resultCriteria = criteria.createCriteria(s);
		if (criteria.equals(resultCriteria)) {
			return this;
		} else {
			return new GenericCriteria<E>(resultCriteria);
		}
	}

	/**
	 * @see org.hibernate.Criteria#createCriteria(java.lang.String, org.hibernate.sql.JoinType)
	 */
	public GenericCriteria<E> createCriteria(String s, JoinType jointype) throws HibernateException {
		Criteria resultCriteria = criteria.createCriteria(s, jointype);
		if (criteria.equals(resultCriteria)) {
			return this;
		} else {
			return new GenericCriteria<E>(resultCriteria);
		}
	}

	/**
	 * @see org.hibernate.Criteria#createCriteria(java.lang.String, java.lang.String)
	 */
	public GenericCriteria<E> createCriteria(String s, String s1) throws HibernateException {
		Criteria resultCriteria = criteria.createCriteria(s, s1);
		if (criteria.equals(resultCriteria)) {
			return this;
		} else {
			return new GenericCriteria<E>(resultCriteria);
		}
	}

	/**
	 * @see org.hibernate.Criteria#createCriteria(java.lang.String, java.lang.String, org.hibernate.sql.JoinType)
	 */
	public GenericCriteria<E> createCriteria(String s, String s1, JoinType jointype) throws HibernateException {
		Criteria resultCriteria = criteria.createCriteria(s, s1, jointype);
		if (criteria.equals(resultCriteria)) {
			return this;
		} else {
			return new GenericCriteria<E>(resultCriteria);
		}
	}

	/**
	 * @see org.hibernate.Criteria#createCriteria(java.lang.String, java.lang.String, org.hibernate.sql.JoinType, org.hibernate.criterion.Criterion)
	 */
	public GenericCriteria<E> createCriteria(String s, String s1, JoinType jointype, Criterion criterion) throws HibernateException {
		Criteria resultCriteria = criteria.createCriteria(s, s1, jointype, criterion);
		if (criteria.equals(resultCriteria)) {
			return this;
		} else {
			return new GenericCriteria<E>(resultCriteria);
		}
	}

	/**
	 * @see org.hibernate.Criteria#setResultTransformer(org.hibernate.transform.ResultTransformer)
	 */
	public GenericCriteria<E> setResultTransformer(ResultTransformer resulttransformer) {
		Criteria resultCriteria = criteria.setResultTransformer(resulttransformer);
		if (criteria.equals(resultCriteria)) {
			return this;
		} else {
			return new GenericCriteria<E>(resultCriteria);
		}
	}

	/**
	 * @see org.hibernate.Criteria#setMaxResults(int)
	 */
	public GenericCriteria<E> setMaxResults(int i) {
		Criteria resultCriteria = criteria.setMaxResults(i);
		if (criteria.equals(resultCriteria)) {
			return this;
		} else {
			return new GenericCriteria<E>(resultCriteria);
		}
	}

	/**
	 * @see org.hibernate.Criteria#setFirstResult(int)
	 */
	public GenericCriteria<E> setFirstResult(int i) {
		Criteria resultCriteria = criteria.setFirstResult(i);
		if (criteria.equals(resultCriteria)) {
			return this;
		} else {
			return new GenericCriteria<E>(resultCriteria);
		}
	}

	/**
	 * @see org.hibernate.Criteria#isReadOnlyInitialized()
	 */
	public boolean isReadOnlyInitialized() {
		return criteria.isReadOnlyInitialized();
	}

	/**
	 * @see org.hibernate.Criteria#isReadOnly()
	 */
	public boolean isReadOnly() {
		return criteria.isReadOnly();
	}

	/**
	 * @see org.hibernate.Criteria#setReadOnly(boolean)
	 */
	public GenericCriteria<E> setReadOnly(boolean flag) {
		Criteria resultCriteria = criteria.setReadOnly(flag);
		if (criteria.equals(resultCriteria)) {
			return this;
		} else {
			return new GenericCriteria<E>(resultCriteria);
		}
	}

	/**
	 * @see org.hibernate.Criteria#setFetchSize(int)
	 */
	public GenericCriteria<E> setFetchSize(int i) {
		Criteria resultCriteria = criteria.setFetchSize(i);
		if (criteria.equals(resultCriteria)) {
			return this;
		} else {
			return new GenericCriteria<E>(resultCriteria);
		}
	}

	/**
	 * @see org.hibernate.Criteria#setTimeout(int)
	 */
	public GenericCriteria<E> setTimeout(int i) {
		Criteria resultCriteria = criteria.setTimeout(i);
		if (criteria.equals(resultCriteria)) {
			return this;
		} else {
			return new GenericCriteria<E>(resultCriteria);
		}
	}

	/**
	 * @see org.hibernate.Criteria#setCacheable(boolean)
	 */
	public GenericCriteria<E> setCacheable(boolean flag) {
		Criteria resultCriteria = criteria.setCacheable(flag);
		if (criteria.equals(resultCriteria)) {
			return this;
		} else {
			return new GenericCriteria<E>(resultCriteria);
		}
	}

	/**
	 * @see org.hibernate.Criteria#setCacheRegion(java.lang.String)
	 */
	public GenericCriteria<E> setCacheRegion(String s) {
		Criteria resultCriteria = criteria.setCacheRegion(s);
		if (criteria.equals(resultCriteria)) {
			return this;
		} else {
			return new GenericCriteria<E>(resultCriteria);
		}
	}

	/**
	 * @see org.hibernate.Criteria#setComment(java.lang.String)
	 */
	public GenericCriteria<E> setComment(String s) {
		Criteria resultCriteria = criteria.setComment(s);
		if (criteria.equals(resultCriteria)) {
			return this;
		} else {
			return new GenericCriteria<E>(resultCriteria);
		}
	}

	/**
	 * @see org.hibernate.Criteria#setFlushMode(org.hibernate.FlushMode)
	 */
	public GenericCriteria<E> setFlushMode(FlushMode flushmode) {
		Criteria resultCriteria = criteria.setFlushMode(flushmode);
		if (criteria.equals(resultCriteria)) {
			return this;
		} else {
			return new GenericCriteria<E>(resultCriteria);
		}
	}

	/**
	 * @see org.hibernate.Criteria#setCacheMode(org.hibernate.CacheMode)
	 */
	public GenericCriteria<E> setCacheMode(CacheMode cachemode) {
		Criteria resultCriteria = criteria.setCacheMode(cachemode);
		if (criteria.equals(resultCriteria)) {
			return this;
		} else {
			return new GenericCriteria<E>(resultCriteria);
		}
	}

	/**
	 * @see org.hibernate.Criteria#list()
	 */
	@SuppressWarnings("unchecked")
	public List<E> list() throws HibernateException {
		return criteria.list();
	}

	/**
	 * @see org.hibernate.Criteria#scroll()
	 */
	public ScrollableResults scroll() throws HibernateException {
		return criteria.scroll();
	}

	/**
	 * @see org.hibernate.Criteria#scroll(org.hibernate.ScrollMode)
	 */
	public ScrollableResults scroll(ScrollMode scrollmode) throws HibernateException {
		return criteria.scroll(scrollmode);
	}

	/**
	 * @see org.hibernate.Criteria#uniqueResult()
	 */
	@SuppressWarnings("unchecked")
	public E uniqueResult() throws HibernateException {
		return (E) criteria.uniqueResult();
	}
}
