package org.phosphoresce.webcore.ext.hibernate4.model;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Table;
import javax.persistence.UniqueConstraint;

import org.phosphoresce.webcore.core.transaction.TransactionUser;
import org.phosphoresce.webcore.ext.hibernate4.transaction.AbstractHibernateEntity;

/**
 * システムユーザーマスタエンティティクラス<br>
 * 
 * @author Kitagawa<br>
 * 
 *<!--
 * 更新日		更新者			更新内容
 * 2013/02/01	Kitagawa		新規作成
 *-->
 */
@Entity
@Table(name = "sm_user", //
uniqueConstraints = { //
@UniqueConstraint(columnNames = { "delete_date", "code" }) //
})
public class SMUser extends AbstractHibernateEntity implements TransactionUser {

	/** ユーザーコード */
	@Column(name = "code", nullable = false, length = 32)
	private String code = null;

	/** パスワード */
	@Column(name = "password", nullable = true, length = 32)
	private String password = null;

	/** ユーザー名(名) */
	@Column(name = "first_name", nullable = false, length = 32)
	private String firstName = null;

	/** ユーザー名(姓) */
	@Column(name = "last_name", nullable = false, length = 32)
	private String lastName = null;

	/**
	 * データベース登録処理前のエンティティ内容の整合処理を実施します。<br>
	 * 当処理はエンティティ毎に処理が異なります。<br>
	 * @see org.phosphoresce.webcore.ext.hibernate4.transaction.AbstractHibernateEntity#validateEntity()
	 */
	@Override
	protected void validateEntity() {
	}

	/**
	 * ユーザーコードを取得します。<br>
	 * @return ユーザーコード
	 */
	public final String getCode() {
		return code;
	}

	/**
	 * ユーザーコードを設定します。<br>
	 * @param code ユーザーコード
	 */
	public final void setCode(String code) {
		this.code = code;
	}

	/**
	 * パスワードを取得します。<br>
	 * @return パスワード
	 */
	public final String getPassword() {
		return password;
	}

	/**
	 * パスワードを設定します。<br>
	 * @param password パスワード
	 */
	public final void setPassword(String password) {
		this.password = password;
	}

	/**
	 * ユーザー名(名)を取得します。<br>
	 * @return ユーザー名(名)
	 */
	public final String getFirstName() {
		return firstName;
	}

	/**
	 * ユーザー名(名)を設定します。<br>
	 * @param firstName ユーザー名(名)
	 */
	public final void setFirstName(String firstName) {
		this.firstName = firstName;
	}

	/**
	 * ユーザー名(姓)を取得します。<br>
	 * @return ユーザー名(姓)
	 */
	public final String getLastName() {
		return lastName;
	}

	/**
	 * ユーザー名(姓)を設定します。<br>
	 * @param lastName ユーザー名(姓)
	 */
	public final void setLastName(String lastName) {
		this.lastName = lastName;
	}
}
