package org.phosphoresce.webcore.ext.hibernate4.exception;

import org.phosphoresce.webcore.core.exception.WebcoreCriticalException;

/**
 * Hibernateフレームワーク初期化時例外クラス<br>
 * 
 * @author Kitagawa<br>
 * 
 *<!--
 * 更新日		更新者			更新内容
 * 2011/07/07	Kitagawa		新規作成
 *-->
 */
public class HibernateConfigureException extends WebcoreCriticalException {

	/**
	 * コンストラクタ<br>
	 * @param code 例外メッセージコード
	 * @param cause 例外要因
	 */
	public HibernateConfigureException(String code, Throwable cause) {
		super(code, cause);
	}

	/**
	 * コンストラクタ<br>
	 * @param code 例外メッセージコード
	 * @param binds 例外メッセージバインドオブジェクト
	 * @param cause 例外要因
	 */
	public HibernateConfigureException(String code, Object[] binds, Throwable cause) {
		super(code, binds, cause);
	}

	/**
	 * コンストラクタ<br>
	 * @param code 例外メッセージ
	 */
	public HibernateConfigureException(String code) {
		super(code);
	}

	/**
	 * コンストラクタ<br>
	 * @param code 例外メッセージ
	 * @param binds 例外メッセージバインドオブジェクト
	 */
	public HibernateConfigureException(String code, Object[] binds) {
		super(code, binds);
	}
}
