package org.phosphoresce.webcore.ext.hibernate4.dao;

import static org.hibernate.criterion.Restrictions.*;

import org.phosphoresce.webcore.ext.hibernate4.model.SMUser;
import org.phosphoresce.webcore.ext.hibernate4.transaction.AbstractHibernateDAO;
import org.phosphoresce.webcore.ext.hibernate4.transaction.GenericCriteria;
import org.phosphoresce.webcore.ext.hibernate4.transaction.HibernateTransactionManager;

/**
 * システムユーザエンティティDAOクラス<br>
 * 
 * @author Kitagawa<br>
 * 
 *<!--
 * 更新日		更新者			更新内容
 * 2013/02/01	Kitagawa		新規作成
 *-->
 */
public class SUserDAO extends AbstractHibernateDAO<SMUser> {

	/**
	 * コンストラクタ<br>
	 * @param transaction トランザクション管理オブジェクト
	 */
	public SUserDAO(HibernateTransactionManager transaction) {
		super(transaction);
	}

	/**
	 * データベースアクセスクラスが扱うエンティティクラスを取得します。<br>
	 * @return 対象エンティティクラス
	 * @see org.phosphoresce.webcore.ext.hibernate4.transaction.AbstractHibernateDAO#getTargetEntityClass()
	 */
	@Override
	public Class<SMUser> getTargetEntityClass() {
		return SMUser.class;
	}

	/**
	 * 指定されたユーザーコードで検索を行います。<br>
	 * @param code ユーザーコード
	 * @return エンティティオブジェクト
	 */
	public SMUser findByCode(String code) {
		GenericCriteria<SMUser> criteria = createCriteriaExcludeDeleted();

		criteria.add(eq("code", code));

		return criteria.uniqueResult();
	}
}
