package org.phosphoresce.webcore.ext.dynapage.model.element;

import org.phosphoresce.webcore.ext.dynapage.model.AbstractModel;
import org.phosphoresce.webcore.ext.dynapage.model.FieldModel;

/**
 * ラジオボタンエレメント定義モデルクラス<br>
 * 
 * @author Kitagawa<br>
 * 
 *<!--
 * 更新日		更新者			更新内容
 * 2013/02/18	Kitagawa		新規作成
 *-->
 */
@FieldModel(template = "/org/phosphoresce/webcore/ext/dynapage/template/element/RadioElement.vm")
public class RadioElement extends AbstractModel {

	/** ラベル文字列 */
	private String label = null;

	/** エレメント名 */
	private String name;

	/** エレメント値 */
	private String value;

	/** 読み込み専用フラグ */
	private boolean readonly;

	/** 編集不可フラグ */
	private boolean disabled;

	/**
	 * コンストラクタ<br>
	 */
	public RadioElement() {
		super();
	}

	/**
	 * ラベル文字列を取得します。<br>
	 * @return ラベル文字列
	 */
	public String getLabel() {
		return label;
	}

	/**
	 * ラベル文字列を設定します。<br>
	 * @param label ラベル文字列
	 */
	public void setLabel(String label) {
		this.label = label;
	}

	/**
	 * エレメント名を取得します。<br>
	 * @return エレメント名
	 */
	public final String getName() {
		return name;
	}

	/**
	 * エレメント名を設定します。<br>
	 * @param name エレメント名
	 */
	public final void setName(String name) {
		this.name = name;
	}

	/**
	 * エレメント値を取得します。<br>
	 * @return エレメント値
	 */
	public final String getValue() {
		return value;
	}

	/**
	 * エレメント値を設定します。<br>
	 * @param value エレメント値
	 */
	public final void setValue(String value) {
		this.value = value;
	}

	/**
	 * 読み込み専用フラグを取得します。<br>
	 * @return 読み込み専用フラグ
	 */
	public final boolean isReadonly() {
		return readonly;
	}

	/**
	 * 読み込み専用フラグを設定します。<br>
	 * @param readonly 読み込み専用フラグ
	 */
	public final void setReadonly(boolean readonly) {
		this.readonly = readonly;
	}

	/**
	 * 編集不可フラグを取得します。<br>
	 * @return 編集不可フラグ
	 */
	public final boolean isDisabled() {
		return disabled;
	}

	/**
	 * 編集不可フラグを設定します。<br>
	 * @param disabled 編集不可フラグ
	 */
	public final void setDisabled(boolean disabled) {
		this.disabled = disabled;
	}
}
