package org.phosphoresce.webcore.ext.dynapage.model.element;

import org.phosphoresce.webcore.ext.dynapage.model.AbstractModel;

/**
 * 文字入力エレメント定義モデル上位抽象クラス<br>
 * 
 * @author Kitagawa<br>
 * 
 *<!--
 * 更新日		更新者			更新内容
 * 2013/02/18	Kitagawa		新規作成
 *-->
 */
public abstract class AbstractInputFieldElement extends AbstractModel {

	/** エレメント名 */
	private String name;

	/** エレメント値 */
	private String value;

	/** 最大入力文字数 */
	private Integer maxlength = null;

	/** 読み込み専用フラグ */
	private boolean readonly;

	/** 編集不可フラグ */
	private boolean disabled;

	/**
	 * コンストラクタ<br>
	 */
	public AbstractInputFieldElement() {
		super();
	}

	/**
	 * エレメント名を取得します。<br>
	 * @return エレメント名
	 */
	public final String getName() {
		return name;
	}

	/**
	 * エレメント名を設定します。<br>
	 * @param name エレメント名
	 */
	public final void setName(String name) {
		this.name = name;
	}

	/**
	 * エレメント値を取得します。<br>
	 * @return エレメント値
	 */
	public final String getValue() {
		return value;
	}

	/**
	 * エレメント値を設定します。<br>
	 * @param value エレメント値
	 */
	public final void setValue(String value) {
		this.value = value;
	}

	/**
	 * 最大入力文字数を取得します。<br>
	 * @return 最大入力文字数
	 */
	public final Integer getMaxlength() {
		return maxlength;
	}

	/**
	 * 最大入力文字数を設定します。<br>
	 * @param maxlength 最大入力文字数
	 */
	public final void setMaxlength(Integer maxlength) {
		this.maxlength = maxlength;
	}

	/**
	 * 読み込み専用フラグを取得します。<br>
	 * @return 読み込み専用フラグ
	 */
	public final boolean isReadonly() {
		return readonly;
	}

	/**
	 * 読み込み専用フラグを設定します。<br>
	 * @param readonly 読み込み専用フラグ
	 */
	public final void setReadonly(boolean readonly) {
		this.readonly = readonly;
	}

	/**
	 * 編集不可フラグを取得します。<br>
	 * @return 編集不可フラグ
	 */
	public final boolean isDisabled() {
		return disabled;
	}

	/**
	 * 編集不可フラグを設定します。<br>
	 * @param disabled 編集不可フラグ
	 */
	public final void setDisabled(boolean disabled) {
		this.disabled = disabled;
	}
}
