package org.phosphoresce.webcore.ext.dynapage.model;

import java.util.LinkedList;
import java.util.List;

/**
 * モデルコンテナ定義モデル上位抽象クラス<br>
 * 
 * @author Kitagawa<br>
 * 
 *<!--
 * 更新日		更新者			更新内容
 * 2013/02/18	Kitagawa		新規作成
 *-->
 */
public abstract class AbstractModelContainer extends AbstractModel {

	/** フィールドモデル */
	private List<AbstractModel> models = new LinkedList<AbstractModel>();

	/**
	 * コンストラクタ<br>
	 */
	public AbstractModelContainer() {
		super();
	}

	/**
	 * フィールドモデルを追加します。<br>
	 * @param model フィールドモデル
	 */
	public final void addModel(AbstractModel model) {
		models.add(model);
	}

	/**
	 * フィールドモデルを削除します。<br>
	 * @param model フィールドモデル
	 */
	public final void removeModel(AbstractModel model) {
		models.remove(model);
	}

	/**
	 * フィールドモデルをクリアします。<br>
	 */
	public final void clearModel() {
		models.clear();
	}

	/**
	 * フィールドモデルを取得します。<br>
	 * @return フィールドモデル
	 * @deprecated テンプレートエンジンからの利用の為に設けられたメソッドであり、Javaからの直接利用は推奨されません
	 */
	@Deprecated
	public final List<AbstractModel> getModels() {
		return models;
	}

	/**
	 * フィールドモデルを設定します。<br>
	 * @param models フィールドモデル
	 */
	private final void setModels(List<AbstractModel> models) {
		this.models = models;
	}
}
