package org.phosphoresce.webcore.core.transaction;

/**
 * トランザクション処理サービスクラス<br>
 * <br>
 * トランザクション処理コンテキストを基にトランザクション処理を行う処理集合体クラスです。<br>
 * 
 * @author Kitagawa<br>
 * 
 *<!--
 * 更新日		更新者			更新内容
 * 2010/07/05	Kitagawa		新規作成
 *-->
 */
public abstract class TransactionService<T extends TransactionManager, U extends TransactionUser, C extends TransactionContext<T, U>> {

	/** トランザクション処理コンテキストオブジェクト */
	private C transactionContext;

	/**
	 * コンストラクタ<br>
	 * @param transactionContext トランザクション処理コンテキストオブジェクト
	 */
	public TransactionService(C transactionContext) {
		if (transactionContext == null) {
			throw new NullPointerException();
		}
		this.transactionContext = transactionContext;
	}
}
