/**
 * サーバーサイド文字列定義リソースアクセスメッセージクラス<br>
 * <br>
 * サーバーサイドで定義されているメッセージをJavascript側で利用する為のインタフェースが提供されます。<br>
 *
 * @author Kitagawa<br>
 *
 *<!--
 * 更新日		更新者				更新内容
 * 2012/07/02	Kitagawa			新規作成
 *-->
 */
var MessageUtil = function() {
};
/**
 * 指定された文字列がnull又は空文字列か判定します。<br>
 * @param {String} value 文字列
 * @returns {Boolean} 文字列がnull又は空文字列の場合にtrueを返却 
 */
MessageUtil.isEmpty = function(value) {
	return value === undefined || value.length === 0;
};

/**
 * 指定された文字列の置換を行い、その結果を取得します。<br>
 * 当メソッドは正規表現は使用しません。<br>
 * @param {String} source 処理の対象の文字列
 * @param {String} before 置換前の文字列
 * @param {String} after 置換後の文字列
 * @return {String} 置換処理後の文字列
 */
MessageUtil.replace = function(source, before, after) {
	if (this.isEmpty(source)) {
		return source;
	}
	if (source.indexOf(before) < 0) {
		return source;
	}

	var result = "";
	var index = source.indexOf(before);
	result += source.substring(0, index) + after;
	if (index + before.length < source.length) {
		var rest = source.substring(index + before.length, source.length);
		result += this.replace(rest, before, after);
	}
	return result;
};

/**
 * 指定された文字列内の{#}に対してパラメータStringオブジェクト配列順に文字列を挿入して提供します。<br>
 * パラメータStringオブジェクトがnullの場合は空文字を挿入します。<br>
 * @param {String} source バインド対象ベース文字列
 * @param {Array} params バインドパラメータStringオブジェクト配列
 * @return {String} バインド編集後文字列
 */
MessageUtil.bind = function(source, params) {
	if (this.isEmpty(source)) {
		return source;
	}
	if (params === undefined || params === null || params.length === 0) {
		return source === null ? "" : source;
	}
	var render = source.toString();
	for ( var i = 0; i <= params.length - 1; i++) {
		var value = params[i];
		value = value === null ? "" : value;
		render = this.replace(render, "{" + i + "}", value);
	}
	return render;
};

var Message = function() {
};

/**
 * 指定されたコードのメッセージを取得します。<br>
 * @param {String} code メッセージコード
 * @param {Array} binds バインド文字列配列
 * @returns {String} メッセージ文字列 
 */
Message.get = function(code, binds) {
	var message = Message.MESSAGES[code];
	if (message) {
		return MessageUtil.bind(message, binds);
	} else {
		return "";
	}
};

/**
 * メッセージ定義<br>
 */
Message.MESSAGES = new Object();
