package org.phosphoresce.webcore.core.logger;

import java.io.IOException;
import java.util.LinkedList;
import java.util.List;

import ch.qos.logback.classic.spi.ILoggingEvent;

/**
 * ラッパーロガー利用時コールトレースオフセットパターンレイアウトエンコーダークラス<br>
 * <br>
 * ラッピングらされたslf4jロガークラス利用時のメソッドコールトレースのオフセットを補正します。<br>
 * オフセットされる階層はCodeConvertLoggerクラスのメソッドラップ階層に依存します。<br>
 * 
 * @author Kitagawa<br>
 * 
 *<!--
 * 更新日		更新者			更新内容
 * 2013/02/08	Kitagawa		新規作成
 *-->
 */
public class CallerOffsetPatternLayoutEncoder extends ch.qos.logback.classic.encoder.PatternLayoutEncoder {

	/** コールトレースオフセット */
	private static int OFFSET = 2;

	/**
	 * ログに対するエンコード処理を実行します。
	 * @see ch.qos.logback.core.encoder.LayoutWrappingEncoder#doEncode(java.lang.Object)
	 */
	@Override
	public void doEncode(ILoggingEvent event) throws IOException {
		StackTraceElement[] elements = event.getCallerData();

		List<StackTraceElement> list = new LinkedList<StackTraceElement>();
		for (int i = OFFSET; i <= elements.length - 1; i++) {
			list.add(elements[i]);
		}

		for (int i = 0; i <= list.size() - 1; i++) {
			elements[i] = list.get(i);
		}

		super.doEncode(event);
	}
}
