package org.phosphoresce.lib.poi.util;

/**
 * 汎用ユーティリティクラス<br>
 * 
 * @author Kitagawa<br>
 * 
 *<!--
 * 更新日		更新者			更新内容
 * 2012/11/19	Kitagawa		新規作成
 *-->
 */
public class PoiUtil {

	/**
	 * コンストラクタ<br>
	 */
	private PoiUtil() {
		super();
	}

	/**
	 * 指定されたExcelセル位置文字列から行インデックスを取得します。<br>
	 * 範囲指定の文字列が指定された場合は開始セルに対して処理されます。<br>
	 * @param value セル位置文字列
	 * @return 行インデックス
	 */
	public static int convertRow(String value) {
		if (PoiStringUtil.isEmpty(value)) {
			return 0;
		} else if (value.toUpperCase().matches("R[0-9]+C[0-9]+.*")) {
			return convertRCRow(value);
		} else {
			return convertANRow(value);
		}
	}

	/**
	 * 指定されたExcelセル位置英字列数事行文字列から行インデックスを取得します。<br>
	 * 範囲指定の文字列が指定された場合は開始セルに対して処理されます。<br>
	 * @param value セル位置文字列
	 * @return 行インデックス
	 */
	public static int convertANRow(String value) {
		if (PoiStringUtil.isEmpty(value)) {
			return 0;
		}
		String buffer = value.toUpperCase();
		buffer = buffer.replaceAll("\\$", "");
		buffer = buffer.replaceAll(":.*", "");
		StringBuilder builder = new StringBuilder();
		for (int i = 0; i <= buffer.length() - 1; i++) {
			char c = buffer.charAt(i);
			if (c >= 'A' && c <= 'Z' && builder.length() <= 0) {
				continue;
			} else if (c >= 'A' && c <= 'Z') {
				break;
			} else if (c >= '0' && c <= '9') {
				builder.append(c);
			}
		}
		if (builder.length() <= 0) {
			return 0;
		}
		return Integer.parseInt(builder.toString()) - 1;
	}

	/**
	 * 指定されたExcelセル位置RC文字列から行インデックスを取得します。<br>
	 * 範囲指定の文字列が指定された場合は開始セルに対して処理されます。<br>
	 * @param value セル位置文字列
	 * @return 行インデックス
	 */
	public static int convertRCRow(String value) {
		if (PoiStringUtil.isEmpty(value)) {
			return 0;
		}
		String buffer = value.toUpperCase();
		buffer = buffer.replaceAll("\\$", "");
		buffer = buffer.replaceAll("\\[", "");
		buffer = buffer.replaceAll("\\]", "");
		buffer = buffer.replaceAll(":.*", "");
		buffer = buffer.replaceAll("C.*", "");
		buffer = buffer.replaceAll("R", "");
		if (PoiStringUtil.isEmpty(buffer)) {
			return 0;
		}
		return Integer.parseInt(buffer) - 1;
	}

	/**
	 * 指定されたExcelセル位置文字列から列インデックスを取得します。<br>
	 * 範囲指定の文字列が指定された場合は開始セルに対して処理されます。<br>
	 * @param value セル位置文字列
	 * @return 列インデックス
	 */
	public static int convertCol(String value) {
		if (PoiStringUtil.isEmpty(value)) {
			return 0;
		} else if (value.toUpperCase().matches("R[0-9]+C[0-9]+.*")) {
			return convertRCCol(value);
		} else {
			return convertANCol(value);
		}
	}

	/**
	 * 指定されたExcelセル位置英字列数事列文字列から列インデックスを取得します。<br>
	 * 範囲指定の文字列が指定された場合は開始セルに対して処理されます。<br>
	 * @param value セル位置文字列
	 * @return 列インデックス
	 */
	public static int convertANCol(String value) {
		if (PoiStringUtil.isEmpty(value)) {
			return 0;
		}
		String buffer = value.toUpperCase();
		buffer = buffer.replaceAll("\\$", "");
		buffer = buffer.replaceAll(":.*", "");
		StringBuilder builder = new StringBuilder();
		for (int i = 0; i <= buffer.length() - 1; i++) {
			char c = buffer.charAt(i);
			if (c >= 'A' && c <= 'Z') {
				builder.append(c);
			} else if (c >= '0' && c <= '9') {
				break;
			}
		}
		if (builder.length() <= 0) {
			return 0;
		}
		int col = 0;
		for (int i = 0; i <= builder.length() - 1; i++) {
			int c = builder.charAt(builder.length() - 1 - i);
			col += ((c - 65) + (i * 26));
		}
		return col;
	}

	/**
	 * 指定されたExcelセル位置RC文字列から列インデックスを取得します。<br>
	 * 範囲指定の文字列が指定された場合は開始セルに対して処理されます。<br>
	 * @param value セル位置文字列
	 * @return 列インデックス
	 */
	public static int convertRCCol(String value) {
		if (PoiStringUtil.isEmpty(value)) {
			return 0;
		}
		String buffer = value.toUpperCase();
		buffer = buffer.replaceAll("\\$", "");
		buffer = buffer.replaceAll("\\[", "");
		buffer = buffer.replaceAll("\\]", "");
		buffer = buffer.replaceAll(":.*", "");
		buffer = buffer.replaceAll("R[0-9]+C", "");
		if (PoiStringUtil.isEmpty(buffer)) {
			return 0;
		}
		return Integer.parseInt(buffer) - 1;
	}
}
