package org.phosphoresce.lib.jod;

import java.io.OutputStream;

/**
 * JODConverterに対する出力ストリームパイプ処理クラス<br>
 * 
 * @author Kitagawa<br>
 * 
 *<!--
 * 更新日		更新者			更新内容
 * 2012/08/03	Kitagawa		新規作成
 *-->
 */
public abstract class JODPipedOutputProcess {

	/** 発生例外オブジェクト */
	private Throwable throwable;

	/**
	 * コンストラクタ<br>
	 */
	public JODPipedOutputProcess() {
		super();
	}

	public abstract void process(OutputStream stream) throws Throwable;

	/**
	 * 発生例外オブジェクトを取得します。<br>
	 * @return 発生例外オブジェクト
	 */
	Throwable getThrowable() {
		return throwable;
	}

	/**
	 * 発生例外オブジェクトを設定します。<br>
	 * @param throwable 発生例外オブジェクト
	 */
	void setThrowable(Throwable throwable) {
		this.throwable = throwable;
	}

	/**
	 * 発生例外オブジェクトが保持されているか判定します。<br>
	 * @return 発生例外オブジェクトが保持されている場合にtrueを返却
	 */
	boolean hasThrowable() {
		return throwable != null;
	}
}
