package org.phosphoresce.lib.jod;

/**
 * LibreOfficeドキュメントコンバート定数インタフェース<br>
 * 
 * @author Kitagawa<br>
 * 
 *<!--
 * 更新日		更新者			更新内容
 * 2012/08/02	Kitagawa		新規作成
 *-->
 */
public interface JODConverterConstants {

	/** LibreOffice実行時オプション定義数(内部処理用) */
	public static final int EXECUTE_OPTIONS_DEFINITION_COUNT = 20;

	/** LibreOffice実行時オプション埋め込み環境定義キー(Linux)(内部処理用) */
	public static final String CONFIG_KEY_LINUX_SOFFICE_OPTION = "linux.soffice.option";

	/** LibreOffice実行時オプション埋め込み環境定義キー(Windows)(内部処理用) */
	public static final String CONFIG_KEY_WINDOWS_SOFFICE_OPTION = "windows.soffice.option";

	/** LibreOffice実行時オプションバインドキー(実行ホスト名)(内部処理用) */
	public static final String EXECUTE_OPTIONS_BIND_KEY_HOST = "host";

	/** LibreOffice実行時オプションバインドキー(実行ポート)(内部処理用) */
	public static final String EXECUTE_OPTIONS_BIND_KEY_PORT = "port";

	/** LibreOffice実行時オプションバインドキー(ユーザーデータパス)(内部処理用) */
	public static final String EXECUTE_OPTIONS_BIND_KEY_USERENV = "userenv";
}
