/**
 * ドキュメント要素ユーティリティクラス<br>
 * <br>
 * ドキュメント要素に対する操作インタフェースを提供します。<br>
 *
 * @author Kitagawa<br>
 *
 *<!--
 * 更新日		更新者				更新内容
 * 2012/07/02	Kitagawa			新規作成
 *-->
 */

/**
 * コンストラクタ<br>
 */
var ElementUtil = function() {
};

/**
 * 指定されたem単位サイズをpx単位に変換します。<br>
 * @param {Number} value em単位サイズ
 * @returns {Number} px単位サイズ 
 */
ElementUtil.convertEmToPx = function(value) {
	var fontSize = parseInt($("body").css("font-size"));
	return value * fontSize;
};

/**
 * 指定されたpx単位サイズをex単位に変換します。<br>
 * @param {Number} value px単位サイズ
 * @returns {Number} em単位サイズ 
 */
ElementUtil.convertPxToEm = function(value) {
	var fontSize = parseInt($("body").css("font-size"));
	return value / fontSize;
};

/**
 * 指定された要素のzIndex値を取得します。<br>
 * @param {Object} target 対象要素又はセレクタ文字列(未指定時はbody要素として実行されます)
 * @returns {Number} zIndex値
 */
ElementUtil.getZIndex = function(target) {
	// 対象要素取得
	target = !target ? "body" : target;

	var elementZIndex = 0;
	var element = $(target)[0];
	if (element.style) {
		elementZIndex = element.style.zIndex;
		if (!elementZIndex) {
			var css = element.currentStyle || document.defaultView.getComputedStyle(element, null);
			elementZIndex = css ? css.zIndex : 0;
		}
		elementZIndex -= 0;
		if (isNaN(elementZIndex)) {
			elementZIndex = 0;
		}
	}

	return elementZIndex;
};
