/**
 * フレームワーク提供スクリプト依存関係解決クラス<br>
 * <br>
 * フレームワークが提供する各種スクリプトの依存関係を解決するクラスです。<br>
 * HTMLから利用する場合は基本的に当スクリプトから各種フレームワーク提供スクリプトをロードします。<br>
 *
 * @author Kitagawa<br>
 *
 *<!--
 * 更新日		更新者				更新内容
 * 2012/07/02	Kitagawa			新規作成
 *-->
 */

var DependResolver = function() {
};

/** キャッシュ無効化フラグ */
DependResolver.IGNORE_CACHE = false;

/** 基底スクリプトパス */
DependResolver.SCRIPT_PATH = "/";

/** 依存関係クラス定義 */
DependResolver.SCRIPTS = {
	"JQueryExtends" : {
		src : "/org/phosphoresce/jquery/jquery.extends.js",
		depends : []
	},
	"Browser" : {
		src : "/org/phosphoresce/javascript/control/Browser.js",
		depends : []
	},
	"Content" : {
		src : "/org/phosphoresce/javascript/control/Content.js",
		depends : ["JQueryExtends"]
	},
	"Dialog" : {
		src : "/org/phosphoresce/javascript/control/Dialog.js",
		depends : []
	},
	"LockLayer" : {
		src : "/org/phosphoresce/javascript/control/LockLayer.js",
		depends : ["JQueryExtends", "ElementUtil", "StringUtil", "EventUtil", "LayoutUtil", "ScriptUtil", "UniqueID"]
	},
	"StringEx" : {
		src : "/org/phosphoresce/javascript/extends/StringEx.js",
		depends : []
	},
	"WindowEx" : {
		src : "/org/phosphoresce/javascript/extends/WindowEx.js",
		depends : ["Dialog"]
	},
	"FieldCorrector" : {
		src : "/org/phosphoresce/javascript/text/FieldCorrector.js",
		depends : ["StringUtil"]
	},
	"FieldValidator" : {
		src : "/org/phosphoresce/javascript/text/FieldValidator.js",
		depends : ["StringUtil"]
	},
	"ElementUtil" : {
		src : "/org/phosphoresce/javascript/util/ElementUtil.js",
		depends : ["StringUtil"]
	},
	"EventUtil" : {
		src : "/org/phosphoresce/javascript/util/EventUtil.js",
		depends : ["JQueryExtends", "ObjectUtil", "StringUtil"]
	},
	"LayoutUtil" : {
		src : "/org/phosphoresce/javascript/util/LayoutUtil.js",
		depends : ["Content"]
	},
	"ObjectUtil" : {
		src : "/org/phosphoresce/javascript/util/ObjectUtil.js",
		depends : []
	},
	"StringUtil" : {
		src : "/org/phosphoresce/javascript/util/StringUtil.js",
		depends : ["StringEx"]
	},
	"ScriptUtil" : {
		src : "/org/phosphoresce/javascript/util/ScriptUtil.js",
		depends : []
	},
	"UniqueID" : {
		src : "/org/phosphoresce/javascript/util/UniqueID.js",
		depends : []
	},
	"Environment" : {
		src : "/org/phosphoresce/web/Environment.js",
		depends : []
	},
	"Submit" : {
		src : "/org/phosphoresce/web/Submit.js",
		depends : []
	},
	"" : {
		src : "",
		depends : []
	}
};

/**
 * クラス初期化処理を行います。<br>
 * @param {Object} options 動作オプション<br>
 * <ul>
 * <li>scriptPath : 基底スクリプトパス(ディフォルト:"/")</li>
 * <li>ignoreCache : キャッシュ無効化フラグ(ディフォルト:true)</li>
 * </ul>
 */
DependResolver.init = function(options) {
	var defaults = {
		scriptPath : "/",
		ignoreCache : true
	};
	var mergedOptions = $.extend({}, defaults, options);
	DependResolver.SCRIPT_PATH = mergedOptions.scriptPath;
	DependResolver.IGNORE_CACHE = mergedOptions.ignoreCache;
};

/**
 * 指定された名称のスクリプトクラスをロードします。<br>
 * @param name {String} スクリプトクラス名
 * @returns {Boolean} スクリプトクラスをロードした場合にtrueを返却
 */
DependResolver.load = function(name) {
	/*
	 * 既にロード済みの場合は処理スキップ
	 */
	if (eval("typeof " + name) !== "undefined") {
		return false;
	}

	/*
	 * 依存関係スクリプト定義取得
	 */
	var dependScripts = DependResolver.SCRIPTS[name];

	if (dependScripts) {
		/*
		 * 依存関係スクリプト処理
		 */
		if (dependScripts.depends) {
			for ( var i = 0; i <= dependScripts.depends.length - 1; i++) {
				var depend = dependScripts.depends[i];
				DependResolver.load(depend);
			}
		}

		/*
		 * 動的スクリプトロード
		 */
		if (dependScripts.src) {
			var url = DependResolver.SCRIPT_PATH + dependScripts.src + (DependResolver.IGNORE_CACHE ? "?_=" + new Date().getTime() : "");
			//console.log("Load Javascript : " + url);

			// InternetExplorer
			var script = document.createElement("script");
			script.setAttribute("type", "text/javascript");
			script.setAttribute("src", url);
			document.getElementsByTagName("head")[0].appendChild(script);

			// GoogleChrome
			var source = "<script type=\"text/javascript\" src=\"" + url + "\"></script>";
			$("head").append($(source));

			return true;
		} else {
			return false;
		}
	}

	return false;
};
