package org.phosphoresce.lib.commons.util;

/**
 * 引数パラメータユーティリティクラス。<br>
 *
 * @author Kitagawa<br>
 *
 *<!--
 * 更新日		更新者			更新内容
 * 2005/05/24	Kitagawa		新規作成
 *-->
 */
public final class ArgumentsUtil {

	/**
	 * コンストラクタ<br>
	 */
	private ArgumentsUtil() {
		//
	}

	/**
	 * 指定されたオプションキー("-x")で指定されているパラメータを取得します。<br>
	 * 指定するキーは必ずハイフン("-")で始まる必要があります。<br>
	 * @param args パラメータ文字列配列
	 * @param key ハイフンから始まるオプションキー
	 * @param judgCap オプションキーの大文字、小文字を判別する場合はtrueを指定
	 * @return 指定されたオプションキーの値、存在しない場合等はnullを返却します。<br>
	 */
	public static String getArgument(String args[], String key, boolean judgCap) {
		if (args == null || key == null) {
			return null;
		}

		String param = null;

		for (int i = 0; i <= args.length - 1; i++) {
			String arg = args[i];
			if ((!judgCap && arg != null && arg.toUpperCase().startsWith(key.toUpperCase())) //
					|| (judgCap && arg != null && arg.startsWith(key))) {
				// オプションキーの後にスペースで区切られてパラメータが記述されている場合
				if (arg.length() == key.length() && i <= args.length - 1) {
					param = args[i + 1].startsWith("-") ? null : args[i + 1];
					i++;
				}
				// オプションキーに続けてパラメータが記述されている場合
				else {
					param = arg.substring(key.length());
				}
			}
		}

		return param == null ? null : (param.trim().length() == 0 ? null : param.trim());
	}

	/**
	 * 指定されたオプションキー("-x")が指定されているか判別します。<br>
	 * 指定するキーは必ずハイフン("-")で始まる必要があります。<br>
	 * 指定されたオプションキーで値が設定されていなくてもオプションキーは指定されている判断します。<br>
	 * @param args パラメータ文字列配列
	 * @param key ハイフンから始まるオプションキー
	 * @param judgCap オプションキーの大文字、小文字を判別する場合はtrueを指定
	 * @return 指定されたオプションキーが指定されている場合はtrueを返却
	 */
	public static boolean hasArgument(String args[], String key, boolean judgCap) {
		if (args == null || key == null) {
			return false;
		}

		for (int i = 0; i <= args.length - 1; i++) {
			String arg = args[i];
			if ((!judgCap && arg != null && arg.toUpperCase().startsWith(key.toUpperCase())) //
					|| (judgCap && arg != null && arg.startsWith(key))) {
				return true;
			}
		}

		return false;
	}
}
