package org.phosphoresce.lib.commons.csv;

import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.Serializable;
import java.util.Iterator;

/**
 * CSVレコードライタークラス<br>
 *
 * @author Kitagawa<br>
 *
 *<!--
 * 更新日		更新者			更新内容
 * 2007/02/16	Kitagawa		新規作成
 *-->
 */
public final class CSVWriter implements Serializable {

	/** 出力ストリーム */
	private PrintWriter writer;

	/**
	 * コンストラクタ<br>
	 * @param stream 出力ストリーム
	 */
	public CSVWriter(OutputStream stream) {
		super();
		this.writer = new PrintWriter(stream);
	}

	/**
	 * ストリームをクローズします。<br>
	 */
	public void close() {
		writer.flush();
		writer.close();
	}

	/**
	 * CSVレコードを出力します。<br>
	 * @param record CSVレコードオブジェクト
	 */
	public void write(CSVRecord record) {
		if (record == null) {
			return;
		}
		writer.println(record.getRecordValue());
		writer.flush();
	}

	/**
	 * CSVレコードを出力します。<br>
	 * @param recordList CSVレコードリストオブジェクト
	 */
	public void write(CSVRecordList recordList) {
		if (recordList == null) {
			return;
		}
		for (Iterator<CSVRecord> iterator = recordList.iterator(); iterator.hasNext();) {
			CSVRecord record = (CSVRecord) iterator.next();
			write(record);
		}
	}
}
