package org.phosphoresce.commons.wpoi.print;

/**
 * ヘッダー/フッターフィールド装飾定義列挙型クラス<br>
 * 
 * @author Kitagawa<br>
 * 
 *<!--
 * 更新日		更新者			更新内容
 * 2012/07/09	Kitagawa		新規作成(バージョン2にアップデート)
 *-->
 */
public enum PoiHeaderFooterDecorate {

	/** 定義文字列(太字) */
	BOLD_FIELD("&B"),

	/** 定義文字列(斜体) */
	ITALIC_FIELD("&I"),

	/** 定義文字列(取り消し線) */
	STRIKETHROUGH_FIELD("&S"),

	/** 定義文字列(下付き) */
	SUBSCRIPT_FIELD("&Y"),

	/** 定義文字列(上付き) */
	SUPERSCRIPT_FIELD("&X"),

	/** 定義文字列(下線) */
	UNDERLINE_FIELD("&U"),

	/** 定義文字列(二重下線) */
	DOUBLE_UNDERLINE_FIELD("&E"),

	;

	/** 定義値 */
	private String value;

	/**
	 * コンストラクタ<br>
	 * @param value 定義値
	 */
	private PoiHeaderFooterDecorate(String value) {
		this.value = value;
	}

	/**
	 * 定義値を取得します。<br>
	 * @return 定義値
	 */
	public String value() {
		return value;
	}

	/**
	 * クラス情報を文字列として提供します。<br>
	 * @see java.lang.Enum#toString()
	 */
	@Override
	public String toString() {
		return value;
	}
}
