package org.phosphoresce.commons.wpoi.dyna;

import org.phosphoresce.commons.wpoi.adapter.PoiCell;
import org.phosphoresce.commons.wpoi.adapter.PoiRow;
import org.phosphoresce.commons.wpoi.exception.PoiException;

/**
 * 動的行バインド処理クラス<br>
 * 
 * @author Kitagawa<br>
 * 
 *<!--
 * 更新日		更新者			更新内容
 * 2012/07/09	Kitagawa		バージョン2にアップデート(PoiDynaSheetから移管)
 *-->
 */
class PoiDynaValueRowSetter {

	/** 処理対象行オブジェクト */
	private PoiRow row;

	/** 処理対象レンジ */
	private PoiDynaRange range;

	/** 動的値オブジェクトマップ */
	private PoiDynaMap dynaMap;

	/**
	 * コンストラクタ<br>
	 * @param row 処理対象行オブジェクト
	 * @param dynaMap 動的値オブジェクトマップ
	 * @param range 処理対象レンジ
	 */
	public PoiDynaValueRowSetter(PoiRow row, PoiDynaMap dynaMap, PoiDynaRange range) {
		super();
		this.row = row;
		this.range = range;
		this.dynaMap = dynaMap;
	}

	/**
	 * バインド処理を行います。<br>
	 */
	public void execute() {
		while (range.hasMoreProcessCol()) {
			PoiCell target = row.getCell(range.getProcessPoint().getProcessColIndex());

			/*
			 * 妥当性チェック
			 */
			// リスト開始識別行の場合はエラー
			if (PoiDynaUtil.isDynaListStartCell(target)) {
				throw new PoiException(target.getString() + " is illegal location");
			}
			// リスト終了識別行の場合はエラー
			if (PoiDynaUtil.isDynaListEndCell(target)) {
				throw new PoiException(target.getString() + " is illegal location");
			}

			/*
			 * バインド処理
			 */
			if (PoiDynaUtil.isDynaValueCell(target)) {
				String dynaKey = PoiDynaUtil.getDynaKey(target);
				if (dynaMap.containsKey(dynaKey)) {
					target.setValue(dynaMap.getDynaObject(dynaKey).getValue());
				} else {
					target.setValue(PoiDynaUtil.getDynaDefaultValue(target));
				}
			}
			range.nextProcessCol();
		}

		range.nextProcessRow();
	}
}
