package org.phosphoresce.commons.wpoi.dyna;

import org.phosphoresce.commons.wpoi.adapter.PoiSheet;

/**
 * 動的オブジェクトバインド処理クラス<br>
 * 
 * @author Kitagawa<br>
 * 
 *<!--
 * 更新日		更新者			更新内容
 * 2012/07/09	Kitagawa		バージョン2にアップデート(PoiDynaSheetから移管)
 *-->
 */
class PoiDynaValueListSetter {

	/** 処理対象シートオブジェクト */
	private PoiSheet sheet;

	/** 処理対象レンジ */
	private PoiDynaRange range;

	/** 動的値オブジェクトリスト */
	private PoiDynaList dynaList;

	/**
	 * コンストラクタ<br>
	 * @param sheet 処理対象シートオブジェクト
	 * @param dynaList 動的値オブジェクトリスト
	 * @param range 処理対象レンジ
	 */
	public PoiDynaValueListSetter(PoiSheet sheet, PoiDynaList dynaList, PoiDynaRange range) {
		super();
		this.sheet = sheet;
		this.range = range;
		this.dynaList = dynaList;
	}

	/**
	 * バインド処理を行います。<br>
	 */
	public void execute() {
		/*
		 * リスト識別行の削除
		 */
		sheet.deleteRow(range.getRowIndexTo());
		sheet.deleteRow(range.getRowIndexFrom());
		range.expand(-2, 0, true);

		/*
		 * リスト定義部レンジ退避
		 */
		PoiDynaRange baseRange = new PoiDynaRange(null, range.getRowIndexFrom(), range.getColIndexFrom(), range.getRowIndexTo(), range.getColIndexTo());

		if (dynaList == null || dynaList.size() <= 0) {
			/*
			 * リストが存在しない場合は該当範囲を削除
			 */
			sheet.deleteRow(baseRange.getRowIndexFrom(), baseRange.getHeight());
			range.expand(-baseRange.getHeight(), 0, true);
		} else {
			/*
			 * リストセットを考慮したリストサイズ分の行を挿入(1サイズ分は元のテンプレート分)
			 */
			for (int i = 1; i <= dynaList.size() - 1; i++) {
				sheet.insertRow(baseRange.getRowIndexFrom() + baseRange.getHeight(), baseRange.getHeight());
				range.expand(baseRange.getHeight(), 0, true);
			}
			/*
			 * 挿入したリストサイズ分の行に対してテンプレートセルを複写
			 */
			for (int i = 1; i <= dynaList.size() - 1; i++) {
				sheet.copy(baseRange.toRange(), baseRange.getRowIndexFrom() + (i * baseRange.getHeight()), 0);
			}
			/*
			 * リストアイテム毎の設定処理
			 */
			for (PoiDynaMap dynaMap : dynaList) {
				PoiDynaRange targetRange = new PoiDynaRange(range, baseRange.getRowIndexFrom(), baseRange.getColIndexFrom(), baseRange.getRowIndexTo(), baseRange.getColIndexTo());
				new PoiDynaValueSetter(sheet, dynaMap, targetRange).execute();
				baseRange.shift(targetRange.getHeight(), 0, true);
			}
		}
	}
}
