package org.phosphoresce.commons.wpoi.adapter;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

import org.phosphoresce.commons.wpoi.PoiWorkbookType;

/**
 * シート抽象クラスクラス<br>
 * <br>
 * POIオブジェクトインタフェースの拡張及び、関連インスタンスへのアクセッサを提供します。<br>
 * また、Excel上でのオペレーションに類似したインタフェースを併せて提供します。<br>
 * 
 * @author Kitagawa<br>
 * 
 *<!--
 * 更新日		更新者			更新内容
 * 2005/11/21	Kitagawa		新規作成
 * 2006/03/09	Kitagawa		IO関連の例外をPoiIOExceptionに変更
 * 2012/07/09	Kitagawa		バージョン2にアップデート
 *-->
 */
public class PoiWorkbook extends PoiBaseWorkbook {

	/**
	 * コンストラクタ<br>
	 * @param type ワークブックタイプ
	 * @param stream ストリームオブジェクト
	 * @throws IOException 正常にクラスを初期化できなかった場合にスローされます
	 */
	public PoiWorkbook(PoiWorkbookType type, InputStream stream) throws IOException {
		super(type, stream);
	}

	/**
	 * コンストラクタ<br>
	 * @param type ワークブックタイプ
	 * @param path ワークブックファイルパス
	 * @throws IOException 正常にクラスを初期化できなかった場合にスローされます
	 */
	public PoiWorkbook(PoiWorkbookType type, String path) throws IOException {
		super(type, path);
	}

	/**
	 * コンストラクタ<br>
	 * @param type ワークブックタイプ
	 * @throws IOException 正常にクラスを初期化できなかった場合にスローされます
	 */
	public PoiWorkbook(PoiWorkbookType type) throws IOException {
		super(type);
	}

	/**
	 * 指定されたストリームオブジェクトにワークブックオブジェクトを保存します。<br>
	 * @param stream ストリームオブジェクト
	 * @throws IOException 正常に出力処理が行えなかった場合にスローされます
	 */
	public void save(OutputStream stream) throws IOException {
		poiWorkbook.write(stream);
	}

	/**
	 * 指定されたファイルパスにワークブックオブジェクトを保存します。<br>
	 * @param path ファイルパス
	 * @throws IOException 正常に保存が行えなかった場合にスローされます
	 */
	public void save(String path) throws IOException {
		FileOutputStream stream = null;
		try {
			stream = new FileOutputStream(new File(path));
			save(stream);
		} finally {
			if (stream != null) {
				stream.close();
			}
		}
	}

	/**
	 * ワークブックを再計算します。<br>
	 */
	public void evaluateAll() {
		PoiBaseUtil.evaluateWorkbook(poiWorkbook);
	}
}
