package org.phosphoresce.library.wpoi.test.logic;

import org.phosphoresce.commons.wpoi.adapter.PoiValue;
import org.phosphoresce.commons.wpoi.dyna.PoiDynaList;
import org.phosphoresce.commons.wpoi.dyna.PoiDynaMap;
import org.phosphoresce.library.wpoi.test.model.Company;
import org.phosphoresce.library.wpoi.test.model.Employee;
import org.phosphoresce.library.wpoi.test.model.Section;
import org.phosphoresce.library.wpoi.test.util.SampleModelFactory;

/**
 * Tv1vONX<br>
 * 
 * @author Kitagawa<br>
 * 
 *<!--
 * XV		XV			XVe
 * 2005/12/07	c			VK쐬
 *-->
 */
public class ExampleLogic1 implements Logic {

	/**
	 * TvpI}bv𐶐܂B<br>
	 * @return TvpI}bvIuWFNg
	 * @throws Exception ɓI}bv𐶐łȂꍇɔ
	 * @see org.phosphoresce.library.wpoi.test.logic.Logic#create()
	 */
	public PoiDynaMap[] create() throws Exception {
		Company company = SampleModelFactory.createSampleCompany();

		Section[] sections = company.getSections();
		Section section = sections[0];

		// p[gݒ
		PoiDynaMap sectionMap = new PoiDynaMap();
		sectionMap.put("code", new PoiValue(section.getCode()));
		sectionMap.put("registerDate", new PoiValue(section.getRegisterDate()));
		sectionMap.put("name", new PoiValue(section.getName()));
		sectionMap.put("employeeCount", new PoiValue(section.getEmployeeCount()));

		// ЈXgp[gݒ
		PoiDynaList employeeList = new PoiDynaList();
		Employee[] employees = section.getEmployees();
		for (int i = 0; i <= employees.length - 1; i++) {
			Employee employee = employees[i];

			PoiDynaMap employeeMap = new PoiDynaMap();
			employeeMap.put("code", new PoiValue(employee.getCode()));
			employeeMap.put("registerDate", new PoiValue(employee.getRegisterDate()));
			employeeMap.put("sex", new PoiValue(employee.getSex()));
			employeeMap.put("name", new PoiValue(employee.getName()));
			employeeMap.put("description", new PoiValue(employee.getDescription()));
			employeeMap.put("sectionCount", new PoiValue(employee.getSectionCount()));
			employeeMap.put("role.name", new PoiValue(employee.getRole().getName()));

			employeeList.add(employeeMap);
		}
		sectionMap.put("employees", employeeList);

		return new PoiDynaMap[] { sectionMap };
	}
}
