package org.phosphoresce.commons.wpoi.dyna;

import org.phosphoresce.commons.wpoi.adapter.PoiCell;
import org.phosphoresce.commons.wpoi.exception.PoiException;

/**
 * POIev[g䃆[eBeBNXB<br>
 * POIev[gpbP[Ŵ݂̎gpB<br>
 * 
 * @author last modified by: Kitagawa<br>
 * LastUpdate: 2005/11/21
 * 
 *<!--
 * XV       XV          XVe
 * 2005/11/21	Kitagawa		VK쐬
 * 2006/03/09	Kitagawa		IlZbg̗OPoiExceptionɕύX
 * 2007/01/16	Kitagawa		IZ̃RgLqɑΉ(Rg͓IZɂāu#vȍ~Ƃ)
 *-->
 */
final class PoiDynaUtil {

	/** IZʃvtBNX */
	public static final String DYNA_PREFIX = "$dyna:";

	/** IZRgʎq */
	public static final String DYNA_COMMNET_IDENTIFIER = "#";

	/** IZ^CvFʏl */
	public static final String DYNA_TYPE_VALUE = "value:";

	/** IZ^CvFXg(Jn) */
	public static final String DYNA_TYPE_LIST_START = "list_start:";

	/** IZ^CvFXg(I) */
	public static final String DYNA_TYPE_LIST_END = "list_end:";

	/**
	 * w肳ꂽPoiCellIuWFNgIZł邩肵܂B<br>
	 * @param pCell PoiCellIuWFNg
	 * @return PoiCellIuWFNgIZłꍇAtrueԋp
	 */
	public static boolean isDynaCell(PoiCell pCell) {
		return pCell != null && pCell.getForceStringValue().startsWith(DYNA_PREFIX);
	}

	/**
	 * IZ^Cv擾܂B<br>
	 * @param pCell PoiCellIuWFNg
	 * @return IZ^Cv
	 * @throws PoiException w肳ꂽPoiCellIuWFNgIZłȂꍇAႵ͕sȓIZ^Cvݒ肳Ăꍇɔ
	 */
	public static String getDynaType(PoiCell pCell) throws PoiException {
		if (!isDynaCell(pCell)) {
			throw new PoiException("w肳ꂽHSSFCellIuWFNg͓IZł͂܂[" + (pCell == null ? "null" : pCell.getForceStringValue() + "]"));
		}

		String dynaTypeAndValue = pCell.getForceStringValue().substring(DYNA_PREFIX.length());

		if (dynaTypeAndValue.startsWith(DYNA_TYPE_VALUE)) {
			return DYNA_TYPE_VALUE;
		} else if (dynaTypeAndValue.startsWith(DYNA_TYPE_LIST_START)) {
			return DYNA_TYPE_LIST_START;
		} else if (dynaTypeAndValue.startsWith(DYNA_TYPE_LIST_END)) {
			return DYNA_TYPE_LIST_END;
		} else {
			throw new PoiException("w肳ꂽHSSFCellIuWFNg͕sȓIZ^Cv`Ă܂");
		}
	}

	/**
	 * IZ̃L[擾܂B<br>
	 * @param pCell PoiCellIuWFNg
	 * @return PoiCellIuWFNgɐݒ肳Ă铮IZL[
	 * @throws PoiException PoiCellIuWFNgIZłȂꍇAsȃ^Cvݒ肳ĂꍇAL[ݒ肳ĂȂꍇɔ
	 */
	public static String getDynaKey(PoiCell pCell) throws PoiException {
		String dynaType = getDynaType(pCell);
		String dynaColumn = pCell.getForceStringValue().substring((DYNA_PREFIX + dynaType).length());
		String dynaKey = dynaColumn.indexOf(DYNA_COMMNET_IDENTIFIER) >= 0 ? dynaColumn.substring(0, dynaColumn.indexOf(DYNA_COMMNET_IDENTIFIER)) : dynaColumn;
		String dynaComment = dynaColumn.indexOf(DYNA_COMMNET_IDENTIFIER) >= 0 ? dynaColumn.substring(dynaColumn.indexOf(DYNA_COMMNET_IDENTIFIER) + 1) : "";

		if ("".equals(dynaKey)) {
			throw new PoiException("w肳ꂽHSSFCellIuWFNgɓIL[w肳Ă܂");
		}

		return dynaKey.trim();
	}

	/**
	 * IZ̃Rg擾܂B<br>
	 * @param pCell PoiCellIuWFNg
	 * @return PoiCellIuWFNgɐݒ肳Ă铮IZL[
	 * @throws PoiException PoiCellIuWFNgIZłȂꍇAsȃ^Cvݒ肳ĂꍇAL[ݒ肳ĂȂꍇɔ
	 */
	public static String getDynaComment(PoiCell pCell) throws PoiException {
		String dynaType = getDynaType(pCell);
		String dynaColumn = pCell.getForceStringValue().substring((DYNA_PREFIX + dynaType).length());
		String dynaKey = dynaColumn.indexOf(DYNA_COMMNET_IDENTIFIER) >= 0 ? dynaColumn.substring(0, dynaColumn.indexOf(DYNA_COMMNET_IDENTIFIER)) : dynaColumn;
		String dynaComment = dynaColumn.indexOf(DYNA_COMMNET_IDENTIFIER) >= 0 ? dynaColumn.substring(dynaColumn.indexOf(DYNA_COMMNET_IDENTIFIER) + 1) : "";

		return dynaComment.trim();
	}

	/**
	 * w肳ꂽPoiCellIuWFNg̃^CvIlZł邩肵܂B<br>
	 * @param pCell PoiCellIuWFNg
	 * @return PoiCellIuWFNg̃^CvIlZłꍇtrueԋp
	 * @throws PoiException ΏۂPoiCellIuWFNgȓIZł͂Ȃꍇɔ
	 */
	public static boolean isDynaValue(PoiCell pCell) throws PoiException {
		return DYNA_TYPE_VALUE.equals(getDynaType(pCell));
	}

	/**
	 * w肳ꂽPoiCellIuWFNg̃^CvIXgJnZł邩肵܂B<br>
	 * @param pCell PoiCellIuWFNg
	 * @return PoiCellIuWFNg̃^CvIlZłꍇtrueԋp
	 * @throws PoiException ΏۂPoiCellIuWFNgȓIZł͂Ȃꍇɔ
	 */
	public static boolean isDynaListStart(PoiCell pCell) throws PoiException {
		return DYNA_TYPE_LIST_START.equals(getDynaType(pCell));
	}

	/**
	 * w肳ꂽPoiCellIuWFNg̃^CvIXgIZł邩肵܂B<br>
	 * @param pCell PoiCellIuWFNg
	 * @return PoiCellIuWFNg̃^CvIlZłꍇtrueԋp
	 * @throws PoiException ΏۂPoiCellIuWFNgȓIZł͂Ȃꍇɔ
	 */
	public static boolean isDynaListEnd(PoiCell pCell) throws PoiException {
		return DYNA_TYPE_LIST_END.equals(getDynaType(pCell));
	}
}
