package org.phosphoresce.commons.socket.http.container;

import org.phosphoresce.commons.socket.http.container.HttpSocketResponse;

import junit.framework.TestCase;

/**
 * TODO クラス説明。<br>
 * 
 * @author Kitagawa<br>
 * 
 *<!--
 * 更新日		更新者			更新内容
 * 2008/11/14	Kitagawa		新規作成
 *-->
 */
public class TestHttpSocketResponse extends TestCase {

	public void testConstructor01() {
		HttpSocketResponse response = new HttpSocketResponse();
		assertEquals("", response.getProtocol());
		assertEquals("", response.getVersion());
		assertEquals(null, response.getStatus());
		assertEquals("", response.getMessage());
		assertEquals("", response.getIdentifier());
		assertEquals(0, response.getHeaders().size());
		assertEquals(0, response.getCookies().size());
	}

	public void testSetIdentifier01() {
		HttpSocketResponse response = new HttpSocketResponse();
		response.setIdentifier("HTTP/1.1 200 OK");
		assertEquals("HTTP", response.getProtocol());
		assertEquals("1.1", response.getVersion());
		assertEquals(200, response.getStatus().getCode());
		assertEquals("OK", response.getMessage());
		assertEquals("HTTP/1.1 200 OK", response.getIdentifier());
		assertEquals(0, response.getHeaders().size());
		assertEquals(0, response.getCookies().size());
	}

	public void testAddHeader01() {
		HttpSocketResponse response = new HttpSocketResponse();
		response.addHeader("Host: localhost");
		assertEquals(1, response.getHeaders().size());
		assertEquals(0, response.getCookies().size());
		assertEquals("localhost", response.getHeader("host").getValue());
	}

	public void testAddHeader02() {
		HttpSocketResponse response = new HttpSocketResponse();
		response.addHeader("Set-Cookie: foo=bar");
		assertEquals(0, response.getHeaders().size());
		assertEquals(1, response.getCookies().size());
		assertEquals("bar", response.getCookie("foo").getValue());
	}

	public void testAddHeader03() {
		HttpSocketResponse response = new HttpSocketResponse();
		response.addHeader("Set-Cookie: foo=bar;hoge=hoge");
		assertEquals(0, response.getHeaders().size());
		assertEquals(1, response.getCookies().size());
		assertEquals("bar", response.getCookie("foo").getValue());
	}

	public void testAddCookie01() {
		HttpSocketResponse response = new HttpSocketResponse();
		response.addCookie("foo=bar");
		assertEquals(0, response.getHeaders().size());
		assertEquals(1, response.getCookies().size());
		assertEquals("bar", response.getCookie("foo").getValue());
	}

	public void testAddCookie02() {
		HttpSocketResponse response = new HttpSocketResponse();
		response.addCookie("foo=bar; hoge=hoge;");
		assertEquals(0, response.getHeaders().size());
		assertEquals(1, response.getCookies().size());
		assertEquals("bar", response.getCookie("foo").getValue());
	}

	public void testGetHeaderStrings01() {
		HttpSocketResponse response = new HttpSocketResponse();
		response.addHeader("Host: localhost");
		response.addHeader("Set-Cookie: foo=bar; hoge=hoge;");
		assertEquals(1, response.getHeaderStrings().length);
		String[] compares = new String[] { "Host: localhost", "Set-Cookie: foo=bar; hoge=hoge" };
		for (int i = 0; i <= response.getHeaderStrings().length - 1; i++) {
			assertEquals(compares[i], response.getHeaderStrings()[i]);
		}
	}
}
