package org.phosphoresce.commons.socket.http;

import org.phosphoresce.commons.socket.http.HttpResponseStatus;

import junit.framework.TestCase;

/**
 * org.phosphoresce.socket.http.HttpResponseStatusクラステストケース<br>
 * 
 * @author Kitagawa<br>
 * 
 *<!--
 * 更新日		更新者			更新内容
 * 2008/11/07	Kitagawa		新規作成
 *-->
 */
public class TestHttpResponseStatus extends TestCase {

	/**
	 * 存在するintコードで取得
	 */
	public void testGetStatus01() {
		HttpResponseStatus status = HttpResponseStatus.getStatus(404);
		assertEquals(404, status.getCode());
		assertEquals("Not Found", status.getMessage());
	}

	/**
	 * 存在する文字列コードで取得
	 */
	public void testGetStatus02() {
		HttpResponseStatus status = HttpResponseStatus.getStatus("404");
		assertEquals(404, status.getCode());
		assertEquals("Not Found", status.getMessage());
	}

	/**
	 * 存在しないintコードで取得
	 */
	public void testGetStatus03() {
		HttpResponseStatus status = HttpResponseStatus.getStatus(999);
		assertEquals(999, status.getCode());
		assertEquals("", status.getMessage());
	}

	/**
	 * 存在しない文字列コードで取得
	 */
	public void testGetStatus04() {
		HttpResponseStatus status = HttpResponseStatus.getStatus("999");
		assertEquals(999, status.getCode());
		assertEquals("", status.getMessage());
	}

	/**
	 * 存在するintコードで取得
	 * ディフォルトメッセージ付き
	 */
	public void testGetStatus05() {
		HttpResponseStatus status = HttpResponseStatus.getStatus(404, "foo");
		assertEquals(404, status.getCode());
		assertEquals("foo", status.getMessage());
	}

	/**
	 * 存在する文字列コードで取得
	 * ディフォルトメッセージ付き
	 */
	public void testGetStatus06() {
		HttpResponseStatus status = HttpResponseStatus.getStatus("404", "foo");
		assertEquals(404, status.getCode());
		assertEquals("foo", status.getMessage());
	}

	/**
	 * 存在しないintコードで取得
	 * ディフォルトメッセージ付き
	 */
	public void testGetStatus07() {
		HttpResponseStatus status = HttpResponseStatus.getStatus(999, "foo");
		assertEquals(999, status.getCode());
		assertEquals("foo", status.getMessage());
	}

	/**
	 * 存在しない文字列コードで取得
	 * ディフォルトメッセージ付き
	 */
	public void testGetStatus08() {
		HttpResponseStatus status = HttpResponseStatus.getStatus("999", "foo");
		assertEquals(999, status.getCode());
		assertEquals("foo", status.getMessage());
	}
}
