package org.phosphoresce.commons.socket.http.util;

import org.phosphoresce.commons.socket.http.container.HttpSocketRequest;
import org.phosphoresce.commons.socket.http.container.HttpSocketResponse;

/**
 * ログ出力ユーティリティクラス<br>
 * (2008.10.31 暫定版)<br>
 * 
 * @author Kitagawa<br>
 * 
 *<!--
 * 更新日		更新者			更新内容
 * 2008/10/31	Kitagawa		新規作成
 *-->
 */
public final class HttpSocketLoggingUtil {

	/**
	 * コンストラクタ<br>
	 */
	private HttpSocketLoggingUtil() {
		super();
	}

	/**
	 * 指定されたリクエスト情報がトレースログ出力対象か判定します。<br>
	 * @param request リクエスト情報
	 * @return トレースログ出力対象の場合にtrueを返却
	 */
	public static boolean isTraceTarget(HttpSocketRequest request) {
		if (request == null || request.getPath() == null) {
			return true;
		} else {
			return !request.getPath().matches( //
					"(.*\\.gif$|.*\\.gif?.*|.*\\.png$|.*\\.png.*|.*\\.jpg$|.*\\.jpg?.*|.*\\.css$|.*\\.css.*|.*\\.js$|.*\\.js.*)" //
			);
		}
	}

	/**
	 * ソケットリクエスト情報トレースログを生成します。<br>
	 * @param request ソケットリクエスト情報
	 * @return ソケットリクエスト情報トレースログ
	 */
	public static String createSocketRequestTrace(HttpSocketRequest request) {
		StringBuffer buffer = new StringBuffer();

		buffer.append("== [ Request Information ] =====================================================").append("\n");

		if (request == null) {
			buffer.append("HttpSocketRequest is null").append("\n");
		} else {
			buffer.append(request.getIdentifier()).append("\n");
			buffer.append("Method : " + request.getMethod()).append("\n");
			buffer.append("Path : " + request.getPath()).append("\n");
			buffer.append("Protocol : " + request.getProtocol()).append("\n");
			buffer.append("Version : " + request.getVersion()).append("\n");
			buffer.append("-- ( Headers ) -----------------------------------------------------------------").append("\n");
			String[] headerStrings = request.getHeaderStrings();
			if (headerStrings.length <= 0) {
				buffer.append("HttpSocketRequestHeader is no data").append("\n");
			}
			for (int i = 0; i <= headerStrings.length - 1; i++) {
				buffer.append(headerStrings[i]).append("\n");
			}
			buffer.append("-- ( Cookies ) -----------------------------------------------------------------").append("\n");
			String[] cookieStrings = request.getCookieStrings();
			if (cookieStrings.length <= 0) {
				buffer.append("HttpSocketRequestCookie is no data").append("\n");
			}
			for (int i = 0; i <= cookieStrings.length - 1; i++) {
				buffer.append(cookieStrings[i]).append("\n");
			}
		}

		return buffer.toString();
	}

	/**
	 * ソケットレスポンス情報トレースログを生成します。<br>
	 * @param response ソケットレスポンス情報
	 * @return ソケットレスポンス情報トレースログ
	 */
	public static String createSocketResponseTrace(HttpSocketResponse response) {
		StringBuffer buffer = new StringBuffer();

		buffer.append("== [ Response Information ] ====================================================").append("\n");

		if (response == null) {
			buffer.append("HttpSocketResponse is null").append("\n");
		} else {
			buffer.append(response.getIdentifier()).append("\n");
			buffer.append("Protocol : " + response.getProtocol()).append("\n");
			buffer.append("Version : " + response.getVersion()).append("\n");
			buffer.append("Status : " + response.getStatus()).append("\n");
			buffer.append("Message : " + response.getMessage()).append("\n");
			buffer.append("-- ( Headers ) -----------------------------------------------------------------").append("\n");
			String[] headerStrings = response.getHeaderStrings();
			if (headerStrings.length <= 0) {
				buffer.append("HttpSocketResponseHeader is no data").append("\n");
			}
			for (int i = 0; i <= headerStrings.length - 1; i++) {
				buffer.append(headerStrings[i]).append("\n");
			}
			buffer.append("-- ( Cookies ) -----------------------------------------------------------------").append("\n");
			String[] cookieStrings = response.getCookieStrings();
			if (cookieStrings.length <= 0) {
				buffer.append("HttpSocketResponseCookie is no data").append("\n");
			}
			for (int i = 0; i <= cookieStrings.length - 1; i++) {
				buffer.append(cookieStrings[i]).append("\n");
			}
		}

		return buffer.toString();
	}
}
