package org.phosphoresce.commons.mail.test;

import java.io.File;
import java.util.Iterator;

import javax.mail.internet.InternetAddress;

import org.phosphoresce.commons.mail.MailMessage;
import org.phosphoresce.commons.mail.MailReciveTransaction;
import org.phosphoresce.commons.mail.configure.MailPOP3Configuration;
import org.phosphoresce.commons.mail.exception.MailException;

/**
 * POP3[MeXgB<br>
 * 
 * @author Kitagawa<br>
 * 
 *<!--
 * XV		XV			XVe
 * 2007/02/24	Kitagawa		VK쐬
 *-->
 */
public class TestPOP3MailRecive extends TestMailAbstract {

	/** eXgpPOP3T[o[ */
	private static final String TEST_SERVER = "";

	/** eXgpPOP3[U[ */
	private static final String TEST_USER = "";

	/** eXgpPOP3pX[h */
	private static final String TEST_PASSWORD = "";

	/**
	 * C\bhB<br>
	 * @param args R}hC
	 * @throws Exception sɗ\ʃG[X[ꂽꍇɔ
	 */
	public static void main(String[] args) throws Exception {

		// ڑIuWFNgyуgUNVIuWFNg
		MailPOP3Configuration configuration = new MailPOP3Configuration(TEST_SERVER, TEST_USER, TEST_PASSWORD);
		MailReciveTransaction transaction = new MailReciveTransaction(configuration);

		// ǂݎpƂăgUNVJn
		transaction.begin(true);

		// ẽg[X
		System.out.println("****************************************************************");
		System.out.println("Message Count        : " + transaction.getMessageCount());
		System.out.println("Unread Message Count : " + transaction.getUnreadMessageCount());
		System.out.println("New Message Count    : " + transaction.getNewMessageCount());
		System.out.println("****************************************************************");

		// bZ[WIuWFNg̎擾
		MailMessage[] messages = transaction.recive();

		// bZ[W̃g[X
		for (int i = 0; i <= messages.length - 1; i++) {
			MailMessage message = messages[i];
			traceMessage(message);
			message.getMailContent().saveAttachResources(new File("c:\\temp"));
		}

		// gUNVN[Y
		transaction.close();
	}

	/**
	 * w肳ꂽ[bZ[WIuWFNgeg[X܂B<br>
	 * @param message [bZ[WIuWFNg
	 * @throws MailException Ƀ[e擾łȂꍇɔ܂
	 */
	public static void traceMessage(MailMessage message) throws MailException {
		System.out.println("================================================================");
		System.out.println("Original Id   : " + message.getId());
		System.out.println("Message Id    : " + message.getMessageId());
		System.out.println("Subject       : " + message.getMailContent().getSubject());
		System.out.println("HTML Message  : " + message.getMailContent().isHTML());
		System.out.println("Send Date     : " + message.getSendDate());
		System.out.print("To            : ");
		for (Iterator iterator = message.getRecipientsContainer().recipientToIterator(); iterator.hasNext();) {
			InternetAddress address = (InternetAddress) iterator.next();
			System.out.print(address.getAddress());
		}
		System.out.println();
		System.out.print("CC            : ");
		for (Iterator iterator = message.getRecipientsContainer().recipientCcIterator(); iterator.hasNext();) {
			InternetAddress address = (InternetAddress) iterator.next();
			System.out.print(address.getAddress());
		}
		System.out.println();
		System.out.print("BCC           : ");
		for (Iterator iterator = message.getRecipientsContainer().recipientBccIterator(); iterator.hasNext();) {
			InternetAddress address = (InternetAddress) iterator.next();
			System.out.print(address.getAddress());
		}
		System.out.println();
		System.out.println("Received Date : " + message.getReceivedDate());
		System.out.print("Attached      : ");
		for (int j = 0; j <= message.getMailContent().getAttachResources().length - 1; j++) {
			System.out.print(message.getMailContent().getAttachResources()[j].getName());
			System.out.print(j < message.getMailContent().getAttachResources().length - 1 ? ", " : "");
		}
		System.out.println();
		System.out.println("----------------------------------------------------------------");
		System.out.println(message.getMailContent().getContent());
		System.out.println("================================================================");
	}
}
