package org.phosphoresce.commons.mail;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.text.SimpleDateFormat;
import java.util.Date;

import javax.mail.Message;
import javax.mail.Message.RecipientType;
import javax.mail.internet.MimeMessage;

import org.phosphoresce.commons.mail.exception.MailIOException;
import org.phosphoresce.commons.mail.exception.MailMessageException;
import org.phosphoresce.commons.mail.mail.MailSafeAccesserUtil;
import org.phosphoresce.commons.util.StringUtil;

/**
 * [bZ[WێNXB<br>
 * 
 * @author Kitagawa<br>
 * 
 *<!--
 * XV		XV			XVe
 * 2007/02/24	Kitagawa		VK쐬
 * 2007/03/01	Kitagawa		ԐMAhX񑀍̒ǉ
 *-->
 */
public final class MailMessage implements MailDeclareInterface {

	/** JavaMailbZ[WIuWFNg */
	private Message message;

	/**
	 * RXgN^<br>
	 * @param message bZ[WIuWFNg
	 */
	MailMessage(Message message) {
		this.message = message;
	}

	/**
	 * RXgN^<br>
	 * @param configuration ݒIuWFNg
	 * @param container MAhXRei
	 * @param content [Rec
	 * @param date M
	 * @throws MailMessageException ɃNXłȂꍇɔ 
	 */
	public MailMessage(MailConfiguration configuration, MailAddressContainer container, MailContent content, Date date) throws MailMessageException {
		super();

		try {
			// MessageIuWFNg̏
			message = new MimeMessage(configuration.getSession());
			MimeMessage mimeMessage = (MimeMessage) message;

			// MAhXݒ
			mimeMessage.addFrom(container.getFromAddresses());

			// ԐMAhXݒ
			mimeMessage.setReplyTo(container.getReplyAddresses());

			// M(TO)AhXݒ
			mimeMessage.addRecipients(RecipientType.TO, container.getRecipientToAddresses());

			// M(CC)AhXݒ
			mimeMessage.addRecipients(RecipientType.CC, container.getRecipientCcAddresses());

			// M(BCC)AhXݒ
			mimeMessage.addRecipients(RecipientType.BCC, container.getRecipientBccAddresses());

			// [\ݒ
			mimeMessage.setSubject(content.getSubject(), content.getSubjectCharset());

			// [eݒ
			mimeMessage.setContent(content.createMultipart());

			// Mݒ
			mimeMessage.setSentDate(date);
		} catch (Exception e) {
			throw new MailMessageException("bZ[WIuWFNg̐Ɏs܂", e);
		}
	}

	/**
	 * RXgN^<br>
	 * @param file eml`[t@C
	 * @throws MailMessageException Ƀ[t@CMessageIuWFNg̐sȂꍇɔ
	 */
	public MailMessage(File file) throws MailMessageException {
		super();
		try {
			FileInputStream is = new FileInputStream(file);
			message = new MimeMessage(null, is);
			is.close();
		} catch (Exception e) {
			throw new MailMessageException("bZ[WIuWFNg̐Ɏs܂", e);
		}
	}

	/**
	 * JavaMailbZ[WIuWFNg擾܂B<br>
	 * @return JavaMailbZ[WIuWFNg
	 */
	Message getMessage() {
		return message;
	}

	/**
	 * JavaMailMimeMessage񋟂郁bZ[WID擾܂B<br>
	 * AANXێMessageIuWFNgMimeMessagehNXłȂꍇ͋󕶎񂪕ԋp܂B<br>
	 * @return bZ[WID
	 * @throws MailMessageException ɃbZ[WID擾łȂꍇɔ
	 */
	public String getMessageId() throws MailMessageException {
		try {
			return (message instanceof MimeMessage) ? ((MimeMessage) message).getMessageID() : "";
		} catch (Exception e) {
			throw new MailMessageException("bZ[WID̎擾Ɏs܂", e);
		}
	}

	/**
	 * [bZ[WID擾܂B<br>
	 * Ŏ擾IDJavaMailMimeMessageIuWFNg񋟂郁bZ[WIDƂ͈قȂ܂B<br>
	 * \bh񋟂ID̓NCAgɂēǂݎpŃbZ[W擾ꍇ
	 * Ǎς݂̃bZ[Wł邩ǂ̔ɗp邱Ƃz肵܂B<br>
	 * @return [bZ[WID
	 * @throws MailMessageException Ƀ[bZ[WID𐶐邱ƂoȂꍇɔ
	 */
	public String getId() throws MailMessageException {
		try {
			StringBuffer buffer = new StringBuffer();
			if (message.getSentDate() != null) {
				buffer.append(new SimpleDateFormat("yyyyMMdd24HHmmssSSS").format(message.getSentDate()));
			} else {
				buffer.append("00000000000000000");
			}
			buffer.append("_");
			if (message instanceof MimeMessage) {
				buffer.append(StringUtil.toMD5Hash(((MimeMessage) message).getMessageID()));
			} else {
				buffer.append(StringUtil.toMD5Hash(message.getSubject()));
			}
			return buffer.toString();
		} catch (Exception e) {
			throw new MailMessageException("[bZ[WIDɎs܂", e);
		}
	}

	/**
	 * bZ[WIuWFNg̑Mt擾܂B<br>
	 * @return bZ[WIuWFNg̑Mt
	 * @throws MailMessageException ɃbZ[WIuWFNg̑Mt擾łȂꍇɔ
	 */
	public Date getSendDate() throws MailMessageException {
		try {
			return message.getSentDate();
		} catch (Exception e) {
			throw new MailMessageException("Mt̎擾Ɏs܂", e);
		}
	}

	/**
	 * bZ[WIuWFNg̎Mt擾܂B<br>
	 * @return bZ[WIuWFNg̎Mt
	 * @throws MailMessageException ɃbZ[WIuWFNg̎Mt擾łȂꍇɔ
	 */
	public Date getReceivedDate() throws MailMessageException {
		try {
			return message.getReceivedDate();
		} catch (Exception e) {
			throw new MailMessageException("Mt̎擾Ɏs܂", e);
		}
	}

	/**
	 * bZ[WIuWFNg̑M擾܂B<br>
	 * @return bZ[WIuWFNg̑M
	 * @throws MailMessageException ɃbZ[WIuWFNg̑M擾łȂꍇɔ
	 */
	public MailAddressContainer getRecipientsContainer() throws MailMessageException {
		try {
			MailAddressContainer container = new MailAddressContainer();
			container.addFrom(MailSafeAccesserUtil.getForm(message));
			container.addReply(MailSafeAccesserUtil.getReplyTo(message));
			container.addRecipientTo(MailSafeAccesserUtil.getRecipients(message, RecipientType.TO));
			container.addRecipientCc(MailSafeAccesserUtil.getRecipients(message, RecipientType.CC));
			container.addRecipientBcc(MailSafeAccesserUtil.getRecipients(message, RecipientType.BCC));
			return container;
		} catch (Exception e) {
			throw new MailMessageException("M̎擾Ɏs܂", e);
		}
	}

	/**
	 * [RecIuWFNg擾܂B<br>
	 * @return [RecIuWFNg
	 * @throws MailMessageException [bZ[WRec񂪐Ɏ擾łȂꍇɔ
	 */
	public MailContent getMailContent() throws MailMessageException {
		return MailContent.createMailContent(message);
	}

	/**
	 * [w肳ꂽt@CIuWFNgɕۑ܂B<br>
	 * w肳ꂽt@CIuWFNgfBNgłꍇ̓[\
	 * t@CƂt@CỸfBNgɑ΂ďo͂܂B<br>
	 * @param file t@CIuWFNg
	 * @throws MailIOException ɓYtt@C̏o͂sȂꍇɔ
	 */
	public void save(File file) throws MailIOException {
		try {
			File target = file.isDirectory() ? new File((file.getAbsolutePath().endsWith(File.separator) ? file.getAbsolutePath() : file.getAbsolutePath() + File.separator) + StringUtil.escapeFilename(getMailContent().getSubject(), "_") + EMAIL_EXTENSION)
					: file;
			message.writeTo(new FileOutputStream(target));
		} catch (Exception e) {
			throw new MailIOException("[bZ[Wt@C̕ۑɎs܂", e);
		}
	}

	/**
	 * [w肳ꂽt@CpXɕۑ܂B<br>
	 * w肳ꂽt@CpXfBNgłꍇ̓[\
	 * t@CƂt@CỸfBNgɑ΂ďo͂܂B<br>
	 * @param path t@CpX
	 * @throws MailIOException ɓYtt@C̏o͂sȂꍇɔ
	 */
	public void save(String path) throws MailIOException {
		save(new File(path));
	}
}
