package org.phosphoresce.common.graphics.test;

import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.Shape;
import java.awt.geom.Rectangle2D;

import javax.swing.JComponent;

/**
 * ペイント描画テストパネル<br>
 * 
 * @author Kitagawa<br>
 * 
 *<!--
 * 更新日		更新者			更新内容
 * 2008/06/09	Kitagawa		新規作成
 *-->
 */
public class PaintTestPanel extends JComponent {

	/** ペイントオブジェクト */
	private Paint paint;

	/**
	 * コンストラクタ<br>
	 */
	public PaintTestPanel() {
		super();
		initialize();
	}

	/**
	 * コンポーネントを初期化します。<br>
	 */
	private void initialize() {
		this.setOpaque(false);
		this.setDoubleBuffered(true);
	}

	/**
	 * ペイントオブジェクトを取得します。<br>
	 * @return ペイントオブジェクト
	 */
	public Paint getPaint() {
		return paint;
	}

	/**
	 * ペイントオブジェクトを設定します。<br>
	 * @param paint ペイントオブジェクト
	 */
	public void setPaint(Paint paint) {
		this.paint = paint;
	}

	/**
	 * コンポーネントを描画します。<br>
	 * @param graphics グラフィックスオブジェクト
	 * @see javax.swing.JComponent#paintComponent(java.awt.Graphics)
	 */
	protected void paintComponent(Graphics graphics) {
		//super.paintComponent(graphics);
		paintPaint((Graphics2D) graphics);
	}

	/**
	 * ペイントを描画します。<br>
	 * @param graphics グラフィックスオブジェクト
	 */
	protected void paintPaint(Graphics2D graphics) {
		if (getPaint() != null) {
			graphics.setPaint(getPaint());
			Shape shape = new Rectangle2D.Float(0, 0, getWidth(), getHeight());
			graphics.fill(shape);
		}
	}
}
