package org.phosphoresce.commons.eswing;

import java.awt.Dimension;

import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.JCheckBox;

import org.phosphoresce.commons.eswing.core.ESwingComponent;
import org.phosphoresce.commons.eswing.core.ESwingConfig;

/**
 * JCheckBoxgNX<br>
 * 
 * @author Kitagawa<br>
 * 
 *<!--
 * XV		XV			XVe
 * 2007/09/01	Kitagawa		VK쐬
 *-->
 */
public class ECheckBox extends JCheckBox implements ESwingComponent {

	/**
	 * SwinggComponentNX̊gݒs܂B<br>
	 * @see org.phosphoresce.commons.eswing.core.ESwingComponent#dressup()
	 */
	public void dressup() {
		getToolkit().setDynamicLayout(true);
		setDoubleBuffered(true);
		setSize(new Dimension(100, 20));
		setOpaque(false);
	}

	/**
	 * RXgN^<br>
	 * @see JCheckBox#JCheckBox()
	 */
	public ECheckBox() {
		super();
		dressup();
	}

	/**
	 * RXgN^<br>
	 * @param action ActionIuWFNg
	 * @see JCheckBox#JCheckBox(Action)
	 */
	public ECheckBox(Action action) {
		super(action);
		dressup();
	}

	/**
	 * RXgN^<br>
	 * @param icon IconIuWFNg
	 * @param selected Iς݃tO
	 * @see JCheckBox#JCheckBox(Icon, boolean)
	 */
	public ECheckBox(Icon icon, boolean selected) {
		super(icon, selected);
		dressup();
	}

	/**
	 * RXgN^<br>
	 * @param icon IconIuWFNg
	 * @see JCheckBox#JCheckBox(Icon)
	 */
	public ECheckBox(Icon icon) {
		super(icon);
		dressup();
	}

	/**
	 * RXgN^<br>
	 * @param text x
	 * @param selected Iς݃tO
	 * @see JCheckBox#JCheckBox(String, boolean)
	 */
	public ECheckBox(String text, boolean selected) {
		super(text, selected);
		dressup();
	}

	/**
	 * RXgN^<br>
	 * @param text x
	 * @param icon IconIuWFNg
	 * @param selected Iς݃tO
	 * @see JCheckBox#JCheckBox(String, Icon, boolean)
	 */
	public ECheckBox(String text, Icon icon, boolean selected) {
		super(text, icon, selected);
		dressup();
	}

	/**
	 * RXgN^<br>
	 * @param text x
	 * @param icon IconIuWFNg
	 * @see JCheckBox#JCheckBox(String, Icon)
	 */
	public ECheckBox(String text, Icon icon) {
		super(text, icon);
		dressup();
	}

	/**
	 * RXgN^<br>
	 * @param text x
	 * @see JCheckBox#JCheckBox(String)
	 */
	public ECheckBox(String text) {
		super(text);
		dressup();
	}
}
