package org.phosphoresce.commons.eswing.table;

import java.awt.Color;
import java.awt.Component;

import javax.swing.JTable;
import javax.swing.table.DefaultTableCellRenderer;

import org.phosphoresce.commons.eswing.core.ESwingConfig;

/**
 * gJTablepfBtHg_NX<br>
 * _NX̓_ƂĎgpeJTableIuWFNgێ܂B<br>
 * 
 * @author Kitagawa<br>
 * 
 *<!--
 * XV		XV			XVe
 * 2007/09/02	Kitagawa		VK쐬
 *-->
 */
public class ETableCellDefaultRenderer extends DefaultTableCellRenderer {

	/** ee[uIuWFNg */
	private JTable parentTable;

	/**
	 * RXgN^<br>
	 * @param table JTableIuWFNg
	 */
	public ETableCellDefaultRenderer(JTable table) {
		super();
		this.parentTable = table;
	}

	/**
	 * RXgN^<br>
	 */
	private ETableCellDefaultRenderer() {
		this(null);
	}

	/**
	 * ee[uIuWFNg擾܂B<br>
	 * @return ee[uIuWFNg
	 */
	public final JTable getParentTable() {
		return parentTable;
	}

	/**
	 * ee[uIuWFNgݒ肵܂B<br>
	 * @param parentTable ee[uIuWFNg
	 */
	private final void setParentTable(JTable parentTable) {
		this.parentTable = parentTable;
	}

	/**
	 * sʒũIuWFNg̕\R|[lg񋟂܂B<br>
	 * @param table JTableIuWFNg
	 * @param value lIuWFNg
	 * @param isSelected ItO
	 * @param hasFocus tH[JXtO
	 * @param row sʒu
	 * @param column ʒu
	 * @return ComponentIuWFNg
	 * @see javax.swing.table.TableCellRenderer#getTableCellRendererComponent(javax.swing.JTable, java.lang.Object, boolean, boolean, int, int)
	 */
	public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
		super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);

		Color background = table.getBackground();
		Color foreground = table.getForeground();

		if (isSelected) {
			background = table.getSelectionBackground();
			foreground = table.getSelectionForeground();
		}
		if (hasFocus) {
			background = ESwingConfig.getTableFocusedCellBackgroundColor();
			foreground = ESwingConfig.getTableFocusedCellForegroungColor();
		}
		setBackground(background);
		setForeground(foreground);

		return this;
	}
}
