package org.phosphoresce.commons.database.container;

import java.io.Serializable;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;

/**
 * f[^x[XXL[}ێNX<br>
 * 
 * @author Kitagawa<br>
 * 
 *<!--
 * XV		XV			XVe
 * 2007/09/18	Kitagawa		VK쐬
 *-->
 */
public final class DatabaseSchema implements Serializable, DatabaseTableHolder {

	/** f[^x[XXL[}ێIuWFNg */
	private DatabaseSchemaHolder schemaHolder = null;

	/** f[^x[XXL[} */
	private String name = null;

	/** e[uXg */
	private List tableList = null;

	/**
	 * RXgN^<br>
	 * @param name f[^x[XXL[}
	 */
	protected DatabaseSchema(String name) {
		this.schemaHolder = null;
		this.name = name;
		this.tableList = new LinkedList();
	}

	/**
	 * RXgN^<br>
	 */
	private DatabaseSchema() {
		this(null);
	}

	/**
	 * f[^x[XXL[}擾܂B<br>
	 * @return f[^x[XXL[}
	 * @see org.phosphoresce.commons.database.container.DatabaseHoldingContainer#getName()
	 */
	public String getName() {
		return name;
	}

	/**
	 * e[uXgCe[^擾܂B<br>
	 * @return e[uXgCe[^
	 * @see org.phosphoresce.commons.database.container.DatabaseTableHolder#getTableListIterator()
	 */
	public Iterator getTableListIterator() {
		return tableList.iterator();
	}

	/**
	 * e[uXg擾܂B<br>
	 * @return e[uXg
	 * @see org.phosphoresce.commons.database.container.DatabaseTableHolder#getTableListCount()
	 */
	public int getTableListCount() {
		return tableList.size();
	}

	/**
	 * e[u擾܂B<br>
	 * @param name e[u
	 * @return e[u
	 * @see org.phosphoresce.commons.database.container.DatabaseTableHolder#getTable(java.lang.String)
	 */
	public DatabaseTable getTable(String name) {
		String key = name == null ? "" : name;
		for (Iterator iterator = tableList.iterator(); iterator.hasNext();) {
			DatabaseTable table = (DatabaseTable) iterator.next();
			if (key.equals(table.getName())) {
				return table;
			}
		}
		return null;
	}

	/**
	 * f[^x[XXL[}ێIuWFNgݒ肵܂B<br>
	 * @param schemaHolder f[^x[XXL[}ێIuWFNg
	 */
	protected void setSchemaHolder(DatabaseSchemaHolder schemaHolder) {
		this.schemaHolder = schemaHolder;
	}

	/**
	 * f[^x[XXL[}ێIuWFNg擾܂B<br>
	 * @return f[^x[XXL[}ێIuWFNg
	 */
	public DatabaseSchemaHolder getSchemaHolder() {
		return schemaHolder;
	}

	/**
	 * w肳ꂽe[uIuWFNgǉ܂B<br>
	 * @param table e[uIuWFNg
	 */
	protected void addTable(DatabaseTable table) {
		tableList.add(table);
	}
}
