package org.phosphoresce.commons.database.container;

import java.io.Serializable;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;

/**
 * f[^x[XJ^OێNX<br>
 * 
 * @author Kitagawa<br>
 * 
 *<!--
 * XV		XV			XVe
 * 2007/09/18	Kitagawa		VK쐬
 *-->
 */
public final class DatabaseCatalog implements Serializable, DatabaseSchemaHolder, DatabaseTableHolder {

	/** J^OێIuWFNg */
	private DatabaseCatalogHolder catalogHolder = null;

	/** f[^x[XJ^O */
	private String name = null;

	/** XL[}Xg */
	private List schemaList = null;

	/** e[uXg */
	private List tableList = null;

	/**
	 * RXgN^<br>
	 * @param name f[^x[XJ^O
	 */
	protected DatabaseCatalog(String name) {
		this.catalogHolder = null;
		this.name = name;
		this.schemaList = new LinkedList();
		this.tableList = new LinkedList();
	}

	/**
	 * RXgN^<br>
	 */
	private DatabaseCatalog() {
		this(null);
	}

	/**
	 * f[^x[XJ^O擾܂B<br>
	 * @return f[^x[XJ^O
	 * @see org.phosphoresce.commons.database.container.DatabaseHoldingContainer#getName()
	 */
	public String getName() {
		return name;
	}

	/**
	 * XL[}XgCe[^擾܂B<br>
	 * @return XL[}XgCe[^
	 * @see org.phosphoresce.commons.database.container.DatabaseSchemaHolder#getSchemaListIterator()
	 */
	public Iterator getSchemaListIterator() {
		return schemaList.iterator();
	}

	/**
	 * XL[}Xg擾܂B<br>
	 * @return XL[}Xg
	 * @see org.phosphoresce.commons.database.container.DatabaseSchemaHolder#getSchemaListCount()
	 */
	public int getSchemaListCount() {
		return schemaList.size();
	}

	/**
	 * XL[}擾܂B<br>
	 * @param name XL[}
	 * @return XL[}
	 * @see org.phosphoresce.commons.database.container.DatabaseSchemaHolder#getSchema(java.lang.String)
	 */
	public DatabaseSchema getSchema(String name) {
		String key = name == null ? "" : name;
		for (Iterator iterator = schemaList.iterator(); iterator.hasNext();) {
			DatabaseSchema schema = (DatabaseSchema) iterator.next();
			if (key.equals(schema.getName())) {
				return schema;
			}
		}
		return null;
	}

	/**
	 * e[uXgCe[^擾܂B<br>
	 * @return e[uXgCe[^
	 * @see org.phosphoresce.commons.database.container.DatabaseTableHolder#getTableListIterator()
	 */
	public Iterator getTableListIterator() {
		return tableList.iterator();
	}

	/**
	 * e[uXg擾܂B<br>
	 * @return e[uXg
	 * @see org.phosphoresce.commons.database.container.DatabaseTableHolder#getTableListCount()
	 */
	public int getTableListCount() {
		return tableList.size();
	}

	/**
	 * e[u擾܂B<br>
	 * @param name e[u
	 * @return e[u
	 * @see org.phosphoresce.commons.database.container.DatabaseTableHolder#getTable(java.lang.String)
	 */
	public DatabaseTable getTable(String name) {
		String key = name == null ? "" : name;
		for (Iterator iterator = tableList.iterator(); iterator.hasNext();) {
			DatabaseTable table = (DatabaseTable) iterator.next();
			if (key.equals(table.getName())) {
				return table;
			}
		}
		return null;
	}

	/**
	 * J^OێIuWFNg擾܂B<br>
	 * @return J^OێIuWFNg
	 */
	public DatabaseCatalogHolder getCatalogHolder() {
		return catalogHolder;
	}

	/**
	 * J^OێIuWFNgݒ肵܂B<br>
	 * @param catalogHolder J^OێIuWFNg
	 */
	protected void setCatalogHolder(DatabaseCatalogHolder catalogHolder) {
		this.catalogHolder = catalogHolder;
	}

	/**
	 * w肳ꂽXL[}IuWFNgǉ܂B<br>
	 * @param schema XL[}IuWFNg
	 */
	protected void addSchema(DatabaseSchema schema) {
		schemaList.add(schema);
	}

	/**
	 * w肳ꂽe[uIuWFNgǉ܂B<br>
	 * @param table e[uIuWFNg
	 */
	protected void addTable(DatabaseTable table) {
		tableList.add(table);
	}
}
