package org.phosphoresce.commons.database;

import java.sql.DatabaseMetaData;
import java.sql.SQLException;
import java.util.LinkedList;
import java.util.List;
import java.util.StringTokenizer;

import org.phosphoresce.commons.database.core.DatabaseSession;
import org.phosphoresce.commons.database.exception.DatabaseSessionException;
import org.phosphoresce.commons.database.exception.ResultSetAccessException;

/**
 * f[^x[XNGdlێIuWFNg<br>
 * IuWFNgDatabaseMetaData񋟂̂NGdlɊւ݂̂񋟂܂B<br>
 * {IɂDatabaseMetaData񋟂C^tF[XɏϏ܂B<br>
 * 
 * @author Kitagawa<br>
 * 
 *<!--
 * XV		XV			XVe
 * 2007/08/31	Kitagawa		VK쐬
 *-->
 */
public class DatabaseQueryspec {

	/** f[^x[XZbVIuWFNg */
	private DatabaseSession session;

	/**
	 * RXgN^<br>
	 * @param session f[^x[XZbVIuWFNg
	 */
	public DatabaseQueryspec(DatabaseSession session) {
		super();
		this.session = session;
	}

	/**
	 * RXgN^<br>
	 */
	private DatabaseQueryspec() {
		this(null);
	}

	/**
	 * f[^x[X^f[^擾܂B<br>
	 * @return f[^x[X^f[^
	 * @throws DatabaseSessionException f[^x[XڑOꍇɃX[܂
	 * @throws ResultSetAccessException ResultSetIuWFNgɑ΂ĐɃANZXłȂꍇɔ
	 */
	private DatabaseMetaData getDatabaseMetaData() throws DatabaseSessionException, ResultSetAccessException {
		try {
			return session.getConnection().getMetaData();
		} catch (SQLException e) {
			throw new ResultSetAccessException("failed to get database meta data.", e);
		}
	}

	/**
	 * pň͂܂ĂȂʖɎgpł邷ׂĂ̓ꕶ(a-zAA-ZA0-9A _ ȊO)擾܂B
	 * @return pň͂܂ĂȂʖɎgpł邷ׂĂ̓ꕶ
	 * @throws DatabaseSessionException f[^x[XڑOꍇɃX[܂
	 * @throws ResultSetAccessException ResultSetIuWFNgɑ΂ĐɃANZXłȂꍇɔ
	 */
	public String getExtraNameCharacters() throws DatabaseSessionException, ResultSetAccessException {
		try {
			return session.getConnection().getMetaData().getExtraNameCharacters();
		} catch (AbstractMethodError e) {
			return "";
		} catch (SQLException e) {
			throw new ResultSetAccessException("failed to get extra name characters.", e);
		}
	}

	/**
	 * SQLʎqp̂Ɏgp镶擾܂B<br>
	 * @return SQLʎqp̂Ɏgp镶
	 * @throws DatabaseSessionException f[^x[XڑOꍇɃX[܂
	 * @throws ResultSetAccessException ResultSetIuWFNgɑ΂ĐɃANZXłȂꍇɔ
	 */
	public String getIdentifierQuoteString() throws DatabaseSessionException, ResultSetAccessException {
		try {
			return session.getConnection().getMetaData().getIdentifierQuoteString();
		} catch (AbstractMethodError e) {
			return "";
		} catch (SQLException e) {
			throw new ResultSetAccessException("failed to get identifier quote string.", e);
		}
	}

	/**
	 * ̃f[^x[XŎgp\ȃR}ŋ؂w֐̃Xg擾܂B<br>
	 * @return ̃f[^x[XŎgp\ȃR}ŋ؂w֐̃X
	 * @throws DatabaseSessionException f[^x[XڑOꍇɃX[܂
	 * @throws ResultSetAccessException ResultSetIuWFNgɑ΂ĐɃANZXłȂꍇɔ
	 */
	public List getNumericFunctionList() throws DatabaseSessionException, ResultSetAccessException {
		try {
			List list = new LinkedList();
			for (StringTokenizer tokenizer = new StringTokenizer(session.getConnection().getMetaData().getNumericFunctions(), ","); tokenizer.hasMoreTokens();) {
				list.add(tokenizer.nextToken());
			}
			return list;
		} catch (AbstractMethodError e) {
			return new LinkedList();
		} catch (SQLException e) {
			throw new ResultSetAccessException("failed to get numeric function list.", e);
		}
	}

	/**
	 * ChJ[hGXP[v̂Ɏgpł镶擾܂B<br>
	 * @return ChJ[hGXP[v̂Ɏgpł镶
	 * @throws DatabaseSessionException f[^x[XڑOꍇɃX[܂
	 * @throws ResultSetAccessException ResultSetIuWFNgɑ΂ĐɃANZXłȂꍇɔ
	 */
	public String getSearchStringEscape() throws DatabaseSessionException, ResultSetAccessException {
		try {
			return session.getConnection().getMetaData().getSearchStringEscape();
		} catch (AbstractMethodError e) {
			return "";
		} catch (SQLException e) {
			throw new ResultSetAccessException("failed to get search string escape.", e);
		}
	}

	/**
	 * ̃f[^x[XSQLL[[hłāASQL92̃L[[hł͂ȂAׂẴL[[hXg擾܂B<br>
	 * @return ̃f[^x[XSQLL[[hłāASQL92̃L[[hł͂ȂAׂẴL[[hXg
	 * @throws DatabaseSessionException f[^x[XڑOꍇɃX[܂
	 * @throws ResultSetAccessException ResultSetIuWFNgɑ΂ĐɃANZXłȂꍇɔ
	 */
	public List getSQLKeywordList() throws DatabaseSessionException, ResultSetAccessException {
		try {
			List list = new LinkedList();
			for (StringTokenizer tokenizer = new StringTokenizer(session.getConnection().getMetaData().getSQLKeywords(), ","); tokenizer.hasMoreTokens();) {
				list.add(tokenizer.nextToken());
			}
			return list;
		} catch (AbstractMethodError e) {
			return new LinkedList();
		} catch (SQLException e) {
			throw new ResultSetAccessException("failed to get SQL keyword list.", e);
		}
	}

	/**
	 * ̃f[^x[XŎgp\ȃVXe֐̃Xg擾܂B<br>
	 * @return ̃f[^x[XŎgp\ȃVXe֐̃Xg
	 * @throws DatabaseSessionException f[^x[XڑOꍇɃX[܂
	 * @throws ResultSetAccessException ResultSetIuWFNgɑ΂ĐɃANZXłȂꍇɔ
	 */
	public List getSystemFunctionList() throws DatabaseSessionException, ResultSetAccessException {
		try {
			List list = new LinkedList();
			for (StringTokenizer tokenizer = new StringTokenizer(session.getConnection().getMetaData().getSystemFunctions(), ","); tokenizer.hasMoreTokens();) {
				list.add(tokenizer.nextToken());
			}
			return list;
		} catch (AbstractMethodError e) {
			return new LinkedList();
		} catch (SQLException e) {
			throw new ResultSetAccessException("failed to get system function list.", e);
		}
	}

	/**
	 * ̃f[^x[XŎgp\ȎԊ֐Ɠt֐̃Xg擾܂B<br>
	 * @return ̃f[^x[XŎgp\ȎԊ֐Ɠt֐̃Xg
	 * @throws DatabaseSessionException f[^x[XڑOꍇɃX[܂
	 * @throws ResultSetAccessException ResultSetIuWFNgɑ΂ĐɃANZXłȂꍇɔ
	 */
	public List getTimeDateFunctionList() throws DatabaseSessionException, ResultSetAccessException {
		try {
			List list = new LinkedList();
			for (StringTokenizer tokenizer = new StringTokenizer(session.getConnection().getMetaData().getTimeDateFunctions(), ","); tokenizer.hasMoreTokens();) {
				list.add(tokenizer.nextToken());
			}
			return list;
		} catch (AbstractMethodError e) {
			return new LinkedList();
		} catch (SQLException e) {
			throw new ResultSetAccessException("failed to get time date function list.", e);
		}
	}
}
