package org.phosphoresce.commons.util;

/**
 * コマンド実行操作ユーティリティクラス<br>
 *
 * @author Kitagawa<br>
 *
 *<!--
 * 更新日		更新者			更新内容
 * 2008/11/05	Kitagawa		新規作成
 *-->
 */
public final class CommandUtil {

	/**
	 * コンストラクタ<br>
	 */
	private CommandUtil() {
		super();
	}

	/**
	 * 指定されたコマンドを実行します。<br>
	 * コマンドプロセスが終了するまでは当メソッドは処理が完了しません。<br>
	 * @param command
	 * @return コマンド実行結果
	 */
	public static CommandResult execAndWait(String command) {
		CommandResult result = new CommandResult();
		try {
			Process process = Runtime.getRuntime().exec(command);
			int rvalue = process.waitFor();
			result.setCode(rvalue);
			result.setOutput(StreamUtil.getStringValue(process.getInputStream()));
			result.setError(StreamUtil.getStringValue(process.getErrorStream()));
		} catch (Throwable e) {
			result.setException(e);
		}
		return result;
	}
}

