package org.phosphoresce.commons.dom;

import java.io.Serializable;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;

import org.phosphoresce.commons.util.DocumentUtil;
import org.w3c.dom.Node;

/**
 * ドキュメントノードアクセスクラス<br>
 * 
 * @author Kitagawa<br>
 * 
 *<!--
 * 更新日		更新者			更新内容
 * 2010/03/11	Kitagawa		新規作成
 *-->
 */
public class DOMNode implements Serializable {

	/** ノードオブジェクト */
	private Node node;

	/**
	 * コンストラクタ<br>
	 */
	private DOMNode() {
		super();
	}

	/**
	 * コンストラクタ<br>
	 * @param node
	 */
	public DOMNode(Node node) {
		super();
		this.node = node;
	}

	/**
	 * ノードオブジェクトを取得します。<br>
	 * @return ノードオブジェクト
	 */
	public Node getNode() {
		return node;
	}

	/**
	 * 指定された名称のノードアクセスオブジェクトを取得します。<br>
	 * 複数のノードが存在する場合は先頭のノードが返却されます。<br>
	 * @param name ノード名
	 * @return ノードアクセスオブジェクト
	 */
	public DOMNode getChild(String name) {
		return new DOMNode(DocumentUtil.findNode(node, name));
	}

	/**
	 * 指定された名称のノードアクセスオブジェクトを取得します。<br>
	 * @param name ノード名
	 * @return ノードアクセスオブジェクト配列
	 */
	public DOMNode[] getChilds(String name) {
		List result = new LinkedList();
		List list = DocumentUtil.findNodes(node, name);
		for (Iterator iterator = list.iterator(); iterator.hasNext();) {
			Node entry = (Node) iterator.next();
			result.add(new DOMNode(entry));
		}
		return (DOMNode[]) result.toArray(new DOMNode[0]);
	}

	/**
	 * ノードが持つテキスト値を取得します。<br>
	 * @return ノードが持つテキスト値
	 */
	public String getText() {
		if (node == null) {
			return null;
		} else {
			if (node.getChildNodes() == null || node.getChildNodes().getLength() == 0) {
				return null;
			} else {
				if (node.getChildNodes().item(0) == null) {
					return null;
				} else {
					return node.getChildNodes().item(0).getNodeValue();
				}
			}
		}
	}

	/**
	 * 指定された名称の属性値を取得します。<br>
	 * @param name 属性名
	 * @return 属性値
	 */
	public String getAttribute(String name) {
		if (node == null) {
			return null;
		} else {
			if (node.getAttributes() == null) {
				return null;
			} else {
				if (node.getAttributes().getNamedItem(name) == null) {
					return null;
				} else {
					return node.getAttributes().getNamedItem(name).getNodeValue();
				}
			}
		}
	}
}
