/**
 * 共通系JavaScript<br>
 * 
 * @author Kitagawa<br>
 * 
 *<!--
 * 更新日		更新者			更新内容
 * 2009/11/12	Kitagawa		新規作成
 *-->
 */

/**
 * 指定されたコントロールの選択状態を全選択にします。<br>
 * @param control textエレメント
 */
function selectTextRange(control) {
	var range = control.createTextRange();
	range.moveStart("character", 0); 
	range.moveEnd("character", control.value.length); 
	range.select();
    return true;
}

/**
 * 指定されたコントロール値をカンマ編集して設定しなおします。<br>
 * @param control value属性を持つエレメント
 */
function formatCommaValue(control) {
	removeCommaValue(control);
	var value = control.value;
	if (value == +value) {
		value = value.replace(/^[ ]+|[ ]+$/g, "");
		value = "" + value;
	}
    value = value.replace(/^([+-]?)([0]*)/, "$1");
    value = value.replace(/^([+-]?)([.])/, "$10.");
    value = value.replace(/^([+]*)/, "");
    if (value.split(".")[1]) {
    	var franc = value.split(".")[1].replace(/(0{1,})$/, "");
    	if (franc == "") {
    		value = value.split(".")[0];
    	} else {
    		value = value.split(".")[0] + "." + franc;
    	}
    }
    value = value == "" ? "0" : value;
    for (var i = 0; i < value.length / 3; i++) {
        value = value.replace(/^([+-]?\d+)(\d\d\d)/, "$1,$2");
    }
    control.value = correctFractionLength(value);
    return true;
}

/**
 * 指定されたコントロール値のカンマを削除して設定しなおします。<br>
 * @param control value属性を持つエレメント
 */
function removeCommaValue(control) {
	var value = control.value.split(",").join("").replace(/^[ ]+|[ ]+$/g, "");
	control.value = value;
    return true;
}
