package org.phosphoresce.socket.proxy.http;

/**
 * リバースプロキシサーバーセッティングクラス<br>
 * <br>
 * 当クラスはアプリケーション起動中に永続的に情報を保持し、アプリケーション終了時には
 * 情報を全て破棄する揮発的な情報保持クラスとなっています。<br>
 * 
 * @author Kitagawa<br>
 * 
 *<!--
 * 更新日		更新者			更新内容
 * 2008/11/26	Kitagawa		新規作成
 *-->
 */
public class HttpReverseProxySetting {

	/** ディフォルト各種サーバー環境設定ファイル配置パス */
	private static final String DEFAULT_CONFIG_PATH = "conf";

	/** ディフォルトサーバー環境設定ファイル */
	private static final String DEFAULT_CONFIG_NAME = "config.properties";

	/** セルフインスタンス */
	private static HttpReverseProxySetting instance;

	/** サーバー起動時カレント時刻 */
	private long currentTime = System.currentTimeMillis();

	/** 環境設定リソース配置パス */
	private String configPath = DEFAULT_CONFIG_PATH;

	/** ディフォルトサーバー環境設定ファイル */
	private String configName = DEFAULT_CONFIG_NAME;

	/**
	 * コンストラクタ<br>
	 */
	private HttpReverseProxySetting() {
		super();
	}

	/**
	 * クラスインスタンスを取得します。<br>
	 * @return クラスインスタンス
	 */
	public static HttpReverseProxySetting instance() {
		if (instance == null) {
			instance = new HttpReverseProxySetting();
		}
		return instance;
	}

	/**
	 * サーバー起動時カレント時刻を取得します。<br>
	 * @return サーバー起動時カレント時刻
	 */
	public long getCurrentTime() {
		return currentTime;
	}

	/**
	 * サーバー起動時カレント時刻を設定します。<br>
	 * @param currentTime サーバー起動時カレント時刻
	 */
	public void setCurrentTime(long currentTime) {
		this.currentTime = currentTime;
	}

	/**
	 * サーバー起動継続時間を取得します。<br>
	 * @return サーバー起動継続時間
	 */
	public long getAliveTime() {
		return System.currentTimeMillis() - currentTime;
	}

	/**
	 * 環境設定リソース配置パスを取得します。<br>
	 * @return 環境設定リソース配置パス
	 */
	public String getConfigPath() {
		return configPath;
	}

	/**
	 * 環境設定リソース配置パスを設定します。<br>
	 * @param configPath 環境設定リソース配置パス
	 */
	public void setConfigPath(String configPath) {
		this.configPath = configPath;
	}

	/**
	 * ディフォルトサーバー環境設定ファイルを取得します。<br>
	 * @return ディフォルトサーバー環境設定ファイル
	 */
	public String getConfigName() {
		return configName;
	}

	/**
	 * ディフォルトサーバー環境設定ファイルを設定します。<br>
	 * @param configName ディフォルトサーバー環境設定ファイル
	 */
	public void setConfigName(String configName) {
		this.configName = configName;
	}
}
