package org.phosphoresce.resourcecomp.plugin.container;

import java.util.Collection;
import java.util.List;

import org.phosphoresce.resourcecomp.core.Resource;
import org.phosphoresce.resourcecomp.core.enumeration.Status;
import org.phosphoresce.resourcecomp.core.session.CompareSession;
import org.phosphoresce.resourcecomp.exception.IllegalEnumerationException;
import org.phosphoresce.resourcecomp.exception.ResourceOperateException;

/**
 * \[XrReiۏʃNX<br>
 * ێ`ɂĉʃNX݂݌vƂĂ܂B<br>
 * 
 * @author Kitagawa<br>
 * 
 *<!--
 * XV		XV			XVe
 * 2008/03/13	Kitagawa		VK쐬
 *-->
 */
public abstract class CompareAbstractContainer implements CompareContainer {

	/** \[XrZbV */
	protected CompareSession session;

	/**
	 * RXgN^<br>
	 */
	private CompareAbstractContainer() {
		super();
	}

	/**
	 * RXgN^<br>
	 * @param session \[XrZbV
	 * @throws ResourceOperateException ɃNX̏sȂꍇɔ
	 */
	public CompareAbstractContainer(CompareSession session) throws ResourceOperateException {
		super();
		this.session = session;
		init();
	}

	/**
	 * NX܂B<br>
	 * @throws ResourceOperateException ɃNX̏sȂꍇɔ
	 */
	protected abstract void init() throws ResourceOperateException;

	/**
	 * \[Xǉ܂B<br>
	 * @param resource \[XIuWFNg
	 * @throws ResourceOperateException ɑ΃pX̉͂sȂꍇɔ
	 * @see org.phosphoresce.resourcecomp.plugin.container.CompareContainer#add(org.phosphoresce.resourcecomp.core.Resource)
	 */
	public abstract void add(Resource resource) throws ResourceOperateException;

	/**
	 * w肳ꂽ\[X폜܂B<br>
	 * @param resource \[XIuWFNg
	 * @throws ResourceOperateException ɑ΃pX̉͂sȂꍇɔ
	 * @see org.phosphoresce.resourcecomp.plugin.container.CompareContainer#remove(org.phosphoresce.resourcecomp.core.Resource)
	 */
	public abstract void remove(Resource resource) throws ResourceOperateException;

	/**
	 * w肳ꂽ\[XXg폜܂B<br>
	 * @param collection 폜Ώۃ\[XXg
	 * @throws ResourceOperateException ɑ΃pX̉͂sȂꍇɔ
	 * @see org.phosphoresce.resourcecomp.plugin.container.CompareContainer#removeAll(java.util.Collection)
	 */
	public abstract void removeAll(Collection collection) throws ResourceOperateException;

	/**
	 * w肳ꂽrς݃\[XɕێĂ邩肵܂B<br>
	 * @param resource rς݃\[X
	 * @return rς݃\[XɕێĂꍇtrueԋp
	 * @throws ResourceOperateException ɑ΃pX̉͂sȂꍇɔ
	 * @see org.phosphoresce.resourcecomp.plugin.container.CompareContainer#contains(org.phosphoresce.resourcecomp.core.Resource)
	 */
	public abstract boolean contains(Resource resource) throws ResourceOperateException;

	/**
	 * \[XXg擾܂B<br>
	 * @return \[XXg
	 * @throws IllegalEnumerationException sȗ񋓌^R[hw肳ꂽꍇɔ
	 * @see org.phosphoresce.resourcecomp.plugin.container.CompareContainer#getResourceList()
	 */
	public abstract List getResourceList() throws IllegalEnumerationException;

	/**
	 * w肳ꂽXe[^X̃\[XXg擾܂B<br>
	 * @param status Xe[^XXg
	 * @return \[XXg
	 * @throws IllegalEnumerationException sȗ񋓌^R[hw肳ꂽꍇɔ
	 * @see org.phosphoresce.resourcecomp.plugin.container.CompareContainer#getResourceList(org.phosphoresce.resourcecomp.core.enumeration.Status[])
	 */
	public abstract List getResourceList(Status[] status) throws IllegalEnumerationException;
}
